package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import com.beiming.odr.user.api.common.enums.DigitalGuangDongErrorCode;
import lombok.Data;

/**
 * 数字广东返回的数据格式
 */
@Data
public class DigitalGuangDongDTO implements Serializable {

  private int errcode;
  private String errmsg;
  private Object data;

  public DigitalGuangDongDTO(int errcode, String errmsg, Object data) {
    this.errcode = errcode;
    this.errmsg = errmsg;
    this.data = data;
  }

  public DigitalGuangDongDTO(DigitalGuangDongErrorCode errcode, String errmsg) {
    this.errcode = errcode.getCode();
    this.errmsg = errmsg;
  }

  public static DigitalGuangDongDTO success(Object data) {
    return new DigitalGuangDongDTO(DigitalGuangDongErrorCode.SUCCESS.getCode(),
        DigitalGuangDongErrorCode.SUCCESS.getDesc(), data);
  }

  public static DigitalGuangDongDTO failed(DigitalGuangDongErrorCode errorCode, String message) {
    return new DigitalGuangDongDTO(errorCode, message);
  }

}
