package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.enums.CheckFlagEnum;
import lombok.Data;

/**
 * 纠纷类型预警监控新增请求参数
 */

@Data
public class DisputeTypeEarlyWarningMonitorAddReqDTO implements Serializable {


  /**
   * id
   */
  private Long id;

  /**
   * 区域名称
   */
  @NotBlank(message = "{user.areaNameNotBlank}")
  private String areaName;

  /**
   * 区域代码
   */
  @NotBlank(message = "{user.areaCodeNotBlank}")
  private String areaCode;

  /**
   * 机构id
   */
  @NotBlank(message = "{user.orgIdNotBlank}")
  private String organizationId;

  /**
   * 机构名称
   */
  @NotBlank(message = "{user.orgNameNotBlank}")
  private String organizationName;

  /**
   * 纠纷类型代码
   */
  @NotBlank(message = "{user.disputeTypeCodeNotBlank}")
  private String disputeTypeCode;

  /**
   * 纠纷类型名称
   */
  @NotBlank(message = "{user.disputeTypeNameNotBlank}")
  private String disputeTypeName;

  /**
   * 案件状态code
   */
  @NotBlank(message = "{user.caseStatusCodeNotBlank}")
  private String caseStatusCode;

  /**
   * 案件状态name
   */
  @NotBlank(message = "{user.caseStatusNameNotBlank}")
  private String caseStatusName;

  /**
   * 案件数量
   */
  @NotNull(message = "{user.caseNumberNotBlank}")
  private Integer caseNumber;

  /**
   * 时间段代码
   */
  @NotBlank(message = "{user.timeFrameCodeNotBlank}")
  private String timeFrameCode;

  /**
   * 时间段名称
   */
  @NotBlank(message = "{user.timeFrameNameNotBlank}")
  private String timeFrameName;

  /**
   * 是否发送机构管理员
   */
  private Boolean sendOrganizationAdministratorFlag;

  /**
   * 发送短信的手机号码
   */
  private String sendMobiliePhone;

  /**
   * 是否暂停使用，1是，0不是
   */
  private Boolean suspendFlag;


  /**
   * 天数
   */
  private Integer dayNumber;

  /**
   * 纠纷类型是否跳过校验,默认检查，跳过填写 'UN_CHECK'
   * */
  private CheckFlagEnum disputeTypeFlag;

  /**
   * 区域是否跳过校验,默认检查，跳过填写 'UN_CHECK'
   * */
  private CheckFlagEnum areaCodeFlag;

}
