package com.beiming.odr.user.api.util;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

/**
 * 咨询问题导出状态转换
 *
 * @author liubao
 * @date 2024/06/20
 */
public class StatusConverter implements Converter<Integer> {

  @Override
  public Class supportJavaTypeKey() {
    return Integer.class;
  }

  @Override
  public CellDataTypeEnum supportExcelTypeKey() {
    return CellDataTypeEnum.STRING;
  }

  @Override
  public Integer convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
      GlobalConfiguration globalConfiguration) throws Exception {
    return cellData.getStringValue().equals("启用") ? 1 : 0;
  }

  @Override
  public CellData convertToExcelData(Integer value, ExcelContentProperty excelContentProperty,
      GlobalConfiguration globalConfiguration) throws Exception {
    return new CellData(value == 1 ? "启用" : "禁用");
  }
}
