/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.util.sm4util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.openfeign.EncryptFeignClient;
import com.beiming.odr.user.api.dto.ParamsDto;
import com.beiming.odr.user.api.util.sm4util.SM4;
import com.beiming.odr.user.api.util.sm4util.SM4Context;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class SM4Utils {
    private static final Logger log = LoggerFactory.getLogger(SM4Utils.class);
    private static final String SECRET_KEY = "DJodRR_OdR=zHSHL";
    private static final String IV = "ODR_SiNoSOFT=437";
    private static final String UTF_8 = "UTF-8";
    private static final boolean HEX_STRING = false;
    @Resource
    private EncryptFeignClient encryptFeignClient;

    public static String encryptDataEcb(String plainText) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = SECRET_KEY.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetKeyEnc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4CryptEcb(ctx, plainText.getBytes(StandardCharsets.UTF_8));
            String cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptDataEcb(String cipherText) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = SECRET_KEY.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetKeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptDataCbcCopy(String plainText) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = SECRET_KEY.getBytes();
            byte[] ivBytes = IV.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetKeyEnc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, plainText.getBytes(StandardCharsets.UTF_8));
            String cipherText = Base64.encodeBase64String((byte[])encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptDataCbcCopy(String cipherText) {
        try {
            SM4Context ctx = new SM4Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = SECRET_KEY.getBytes();
            byte[] ivBytes = IV.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetKeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String source = "15295793474";
        String target = "xy_db_encrypt_" + SM4Utils.encryptDataCbcCopy(source);
        System.out.println(target);
        String aa = "5+zz7+k1RuqTnFt258MeCLm18y35t83yeIYGf6FVlUc=";
        String s = SM4Utils.decryptDataCbcCopy(aa);
        System.out.println(s);
    }

    public String encryptDataCbc(String plainText) {
        byte[] plainTextByte = plainText.getBytes(StandardCharsets.UTF_8);
        String plainTextParam = Base64Utils.encodeToString((byte[])plainTextByte);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("EncData", plainTextParam);
        ParamsDto param = new ParamsDto();
        param.setObj(map);
        log.info("\u52a0\u5bc6\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)param));
        JSONObject encrypt = this.encryptFeignClient.encryption(param);
        log.info("\u52a0\u5bc6\u7ed3\u679c\uff1a{}", (Object)encrypt);
        Map data = (Map)encrypt.getObject("data", Map.class);
        String encData = (String)data.get("EncData");
        return encData;
    }

    public String decryptDataCbc(String data) {
        ParamsDto paramsDto = new ParamsDto();
        paramsDto.getObj().put("DecryData", data);
        System.out.println("====\u89e3\u5bc6\u53c2\u6570====" + paramsDto);
        JSONObject resVo = this.encryptFeignClient.decryption(paramsDto);
        AssertUtils.assertTrue((1000 == resVo.getInteger("code") ? 1 : 0) != 0, (ResultCode)APIResultCodeEnums.ILLEGAL_PARAMETER, (String)"\u52a0\u5bc6\u7ed3\u679c\u5931\u8d25");
        JSONObject obj = (JSONObject)JSON.parseObject((String)JSON.toJSONString((Object)resVo.get((Object)"data")), JSONObject.class);
        String baseValue = obj.get((Object)"DecryData").toString();
        byte[] bytes = Base64Utils.decodeFromString((String)baseValue);
        String decryptValue = new String(bytes, StandardCharsets.UTF_8);
        return decryptValue;
    }
}

