package com.beiming.odr.user.api.common.enums;

public enum UserTypeEnums {

  MEDIATOR("调解员"),
  SPECIALIST("专家"),
  JUDGE("法官"),
  ARBITRATOR("仲裁员"),
  TRANSLATOR("翻译机构人员"),
  NOTARY("公证人员"),
  CONSELOR("咨询师"),
  OTHER("其他机构人员");


  private String name;

  UserTypeEnums(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static String getCodeByName(String name) {
    String result = "MEDIATOR";
    UserTypeEnums[] values = UserTypeEnums.values();
    for (UserTypeEnums typeEnum : values) {
      if (typeEnum.getName().equals(name)) {
        result = typeEnum.name();
      }
    }
    return result;
  }

  public static String getNameByCode(String code) {
    UserTypeEnums[] values = UserTypeEnums.values();
    for (UserTypeEnums typeEnum : values) {
      if (typeEnum.name().equals(code)) {
        return typeEnum.getName();
      }
    }
    return null;
  }
}
