package com.beiming.odr.user.api.common.enums.thirdparty.gdtyrz;

/**
* @Description: 广东省统一认证平台证件枚举
* @Author: JACHE
* @Date: 2020-05-20
*/
public enum GdtyrzLoginEnum {
  /**
  * 个人
  */
  PRC_IDENTITY_CARD("10", "中华人民共和国居民身份证", "09_00015-1"),
  HOME_RETURN_PERMIT("14", "港澳居民来往内地通行证" , "09_00015-255"),
  TAIWAN_RESIDENT_PASS("15", "台湾居民来往大陆通行证", "09_00015-255"),
  PASSPORT("20", "护照", "09_00015-7"),
  RESIDENCE_PERMIT_FOR_HK_MACAO_TAIWAN("22", "港澳台居民居住证", "09_00015-255"),
  FOREIGN_RESIDENCE_PERMANENT_IDCARD("23", "外国人永久居留身份证", "09_00015-255"),
  OTHER_VALID_PERSONAL_ID("40", "其他有效个人身份证件", "09_00015-255"),

  /**
  * 法人
  */
  USCC("49", "统一社会信用代码", "09_00015-255"),
  ORG_CODE_CERTIFICATE("50", "组织机构代码证", "09_00015-255"),
  BUSINESS_PERMITS("51", "工商营业执照", "09_00015-255"),
  TAX_REGISTRATION_CERTIFICATE("60", "税务登记证", "09_00015-255"),
  OTHER_VALID_ORG_ID("80", "其他有效机构身份证件", "09_00015-255"),


  ;

  private String gdCode;
  private String name;
  private String tdhCode;

  GdtyrzLoginEnum(String code, String name, String tdhCode) {
    this.gdCode = code;
    this.name = name;
    this.tdhCode = tdhCode;
  }

  public static String getCardType(String name) {
    return getCardTypeEnum(name).getName();
  }

  public static GdtyrzLoginEnum getCardTypeEnum(String name) {
    GdtyrzLoginEnum result = PRC_IDENTITY_CARD; //默认身份证
    for (GdtyrzLoginEnum cardTypeEnum : GdtyrzLoginEnum.values()) {
      if (cardTypeEnum.getGdCode().equals(name)) {
        result = cardTypeEnum;
      }
    }
    return result;
  }
  public String getName() {
    return name;
  }

  public String getGdCode() {
    return gdCode;
  }

  public String getTdhCode() {
    return tdhCode;
  }

}
