package com.beiming.odr.user.api.dto.requestdto;


import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.UserTypeEnums;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.util.List;


/**
 * 工作人员导入参数
 */
@Data
public class BackstageUserImportReqDTO implements Serializable {

  /**
   * 姓名
   */
  @NotEmpty(message = "姓名不能为空")
  private String userName;


  /**
   * 英文名
   */
  @NotEmpty(message = "英文名不能为空")
  private String userNameEn;



  /**
   * 性别
   */
  @NotEmpty(message = "性别不能为空")
  @Pattern(regexp = "^[男|女]$", message = "性别必须是'男'或'女'")
  private String sex;

  /**
   * 公开状态 1 公开, 2 隐藏
   */
  @NotEmpty(message = "公开状态不能为空")
  @Pattern(regexp = "^(公开|隐藏)$", message = "公开状态必须是'公开'或'隐藏'")
  private String show;


  // 2024-05-15新增
  /**
   * 人员类型
   * 调解员、仲裁员、法官、专家、其他等
   * @see UserTypeEnums
   */

  @NotEmpty(message = "人员类型不能为空")
  @Pattern(regexp = "^(调解员|专家|法官|仲裁员|翻译机构人员|公证人员|其他机构人员|咨询师)$", message = "人员类型不合法")
  private String userType;

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  @NotEmpty(message = "手机号不能为空")
  private String mobilePhone;


  /**
   * 所属机构
   */
  @NotEmpty(message = "所属机构不能为空")
  private String orgName;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 英文介绍
   */
  private String introductionEn;

  /**
   * 中文介绍
   */
  private String introduction;
  /**
   * 职能类型
    */
  @NotEmpty(message = "职能类型不能为空")
  @Pattern(regexp = "^(调解员|咨询师|办案法官|机构管理员|行政区域管理员|纠纷登记员|仲裁员|运维)$", message = "职能类型不合法")
  private String roleType;

  /**
   * 服务机构
   */
  @NotEmpty(message = "服务机构不能为空")
  private String roleOrg;

  private String roleArea;

  /**
   * 所属国家（仲裁员的字段）
   */
  private String country;


  private Boolean isValid;

  private List<String> errorList;

  @JsonIgnore
  private BackstageUserAddReqDTO userAdd;

}
