package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.SupervisionWarningDTO;
import java.util.ArrayList;

/**
 * 监督预警服务列表
 *
 * @author liubao
 * @date 2024/06/21
 */
public interface SupervisionWarningServiceApi {

  /**
   * 添加监督预警
   */
  DubboResult addWarning(SupervisionWarningDTO reqDTO);

  /**
   * 修改监督预警
   */
  DubboResult updateWarning(SupervisionWarningDTO reqDTO);

  /**
   * 删除监督预警
   */
  DubboResult deleteWarning(Long id);

  /**
   * 监督预警详情
   */
  DubboResult<SupervisionWarningDTO> searchSupervisionWarning(Long id);

  /**
   * 监督预警列表查询
   */
  DubboResult<ArrayList<SupervisionWarningDTO>> listSupervisionWarnings();

  /**
   * 通过案件类型查询监督预警
   */
  DubboResult<SupervisionWarningDTO> searchSupervisionWarningByCaseType(String caseType);

}
