package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 机构类型枚举
 * @author fanheshui
 *
 */
public enum OrganizationTypeEnum {
  INNER_SPECIAL("内地特邀调解员"),
  HK_AM_TW_SPECIAL("港澳台特邀调解员"),
  LAW_INSTITUTE("律师事务所调解工作室"),
  COLLEGE("高等院校"),
  INTERNET_ENTERPRISE("互联网平台企业"),
  OTHER_COMMITTEE("其他人民调解委员会"),
  OTHER_DISPUTE("其他各类纠纷处理机构");

 
  private String name;

  OrganizationTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 得到一个转换的map
   * @return
   */
  public static Map<String, OrganizationTypeEnum> getNameMap() {
    Map<String, OrganizationTypeEnum> map = new HashMap<>();
    for (OrganizationTypeEnum organizationTypeEnum : OrganizationTypeEnum.values()) {
      map.put(organizationTypeEnum.getName(), organizationTypeEnum);
    }
    return map;
  }

}
