package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.user.api.dto
 * @ClassName: ReportMapCommonDTO
 * @Author: lanqingyun
 * @Description: 世界地图参数
 * @Date: 2024/5/20 16:38
 * @Version: 1.0
 */

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ReportMapCommonDTO implements Serializable {

  private Integer num;

  private String name;

  private String code;

  /**
   * 经度
   */
  private String longitude;

  /**
   * 纬度
   */
  private String latitude;

  private String type;

  private List<ReportMapDTO> marks;
  private List<ReportMapDTO> maps;

}
