package com.beiming.odr.user.api.common.constants;

/**
 * Created by zli on 2018/5/3.
 *
 * 常量
 */
public class UserConst {

  /**
   * 数据库里默认的version值
   */
  public static final Integer DEFAULT_VERSION = 0;

  /**
   * 正则：手机号（精确）
   * <p>
   * 移动：134(0-8)、135、136、137、138、139、147、150、151、152、157、158、159、178、182、183、184、187、188、198
   * </p>
   * <p>
   * 联通：130、131、132、145、155、156、175、176、185、186、166
   * </p>
   * <p>
   * 电信：133、153、173、177、180、181、189、199
   * </p>
   * <p>
   * 全球星：1349
   * </p>
   * <p>
   * 虚拟运营商：170
   * </p>
   */
  public static final String REGEX_MOBILE_EXACT =
      "^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,1,2,3,5-8])|(18[0-9])|166|198|199|193|191|(147))\\d{8}$";
  /**
   * 正则： 身份证格式是否正确
   */
  public static final String REGEX_ID_CARD =
      "^\\d{6}(18|19|20)?\\d{2}(0[1-9]|1[012])(0[1-9]|[12]\\d|3[01])\\d{3}(\\d|[xX])$";
  /**
   * 正则表达式: 验证密码的格式
   */
  public static final String REGEX_PASSWORD = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[$\\S])[A-Za-z\\d$\\S]{20,}";

  /**
   * 默认密码 HngsTymm@102420482448
   */
  public static final String COMMON_PASSWORD = "HngsTymm@102420482448";
  /**
   * 默认密码-md5加密的结果
   */
  public static final String COMMON_PASSWORD_MD5 = "014620fcf724e6dc2480a15e81f5db36";

  /**
   * 禁用状态
   */
  public static final String DISABLE_STATUS_VALUE = "1";

  /**
   * 邮箱的格式
   */
  public static final String REGEX_EMAIL =
      "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";

  /**
   * 市辖区名称常量
   */
  public static final String MUNICIPAL_DISTRICT = "市辖区";

  /**
   * 东莞市编码常量
   */
  public static final String AREA_CODE_DONG_GUANG = "441900000000";

  /**
   * 查询条件为手机号码
   */
  public static final String SEARCH_MOBILE_PHONE = "mobilePhone";

  /**
   * 查询条件为登录名
   */
  public static final String SEARCH_LOGIN_NAME = "loginName";

  /**
   * 查询条件为证件号
   */
  public static final String SEARCH_ID_CARD = "idCard";

  /**
   * 内部测试用户和机构的备注
   */
  public static final String INTERNAL_TEST_REMARK = "INTERNAL_TEST_REMARK";
  /**
   * 石景山区地区代码
   */
  public static final String AREA_CODE_SHIJINGSHAN = "110107000000";

  /**
   * 信访代理人特别纠纷类型前缀
   */
  public static final String DISPUTE_TYPE_PETITION_PREFIX = "PETITION_";
  /**
   * YYYYMMDD格式的字符串
   */
  public static final String REGEX_YYYYMMDD_DATE = "^((\\\\d{2}(([02468][048])|([13579][26]))[\\\\-\\\\/\\\\s]?((((0?[13578])|(1[02]))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])))))|(\\\\d{2}(([02468][1235679])|([13579][01345789]))[\\\\-\\\\/\\\\s]?((((0?[13578])|(1[02]))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\\\-\\\\/\\\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))?$";
  /**
   * 验证数字
   */
  public static final String REGEX_NUMBER_DATA = "^\\d+$";

  /**
   * 选择所有
   */
  public static final String SELECT_ALL_CODE = "ALL";


  public static final String GHODR_WEI_ZHENG = "ghodr_access_token";

  public static final String GHODR_INFO_COLLECT_PREFIX = "gh_";

  public static final String EN = "en_US";

  public static final String TW = "zh_TW";

  // 男童鞋 默认头像Url
  public static final String HEAD_PORTRAIT_URL_AIM_AT_MALE = "https://odr.gzinternetcourt.gov.cn/static/img/avatar_staff_male.a3b48f9.png";

  // 女童鞋 默认头像Url
  public static final String HEAD_PORTRAIT_URL_AIM_AT_FEMALE = "https://odr.gzinternetcourt.gov.cn/static/img/avatar_staff_female.d6b5c12.png";

  // 男用户 默认头像Url
  public static final String HEAD_PORTRAIT_URL_USER_MALE = "https://test.gytj.dg.cn/templates_download/img/avatar_user_male.488a7d8.png";

  // 女用户 默认头像Url
  public static final String HEAD_PORTRAIT_URL_USER_FEMALE = "https://test.gytj.dg.cn/templates_download/img/avatar_user_female.afcd43c.png";
  /** 错误输入密码登录次数统计 */
  public static final String ERROR_LOGIN_TIME_PREFIX = "login_time:";
}
