package com.beiming.odr.user.api.dto.requestdto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import lombok.Data;

/**
 * @author guming
 * @version 1.0
 * @email guming@bmsoft.com.cn
 * @date 2024/6/19
 * @Desc
 */
@Data
public class MessageInfoDTO implements Serializable {

  private static final long serialVersionUID = 7851878297388953488L;
  /**
   * 自增主键
   */
  private Long id;

  /**
   * 发送角色 0-所有群众 1-所有工作人员  2-全部人 3-个人
   */
  private String sendRole;


  /**
   * 消息标题
   */
  private String messageTitle;
  /**
   * 消息内容
   */
  private String messageContent;

  /**
   * 消息状态 0-暂存 1-发布 2-撤回 3 删除
   */
  private Integer status;

  /**
   * 创建时间
   */
  private String createTime;

  /**
   * 发布时间
   */
  private String publishTime;

  /**
   * 发布人
   */
  private String updateUser;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private String updateTime;

  /**
   * 收件人
   */
  private String recipient;


  /**
   * 创建人
   */
  private String createUser;
  /**
   * 关联督办消息ID
   */
  private String relationalId;

  /**
   * 平台 0 公众端  1 后台管理
   */
  private String plantForm;

  /**
   * 平台  1 已经回复
   */
  private String reply;

  /**
   * 消息是否可以回复 0-否 1-是
   */
  private Integer canReply = 0;


}
