package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author jiangfan
 * @date 2024/06/27
 */
@Data
@EncryptDecryptData
public class ScheduleRequestDTO implements Serializable {

  /**
   * id
   */
  private String id;

  /**
   * 事务名称
   */
  private String name;

  /**
   * 开始时间
   */
  private String startTime;

  /**
   * 关联案件Id
   */
  private String caseId;

  /**
   * 案号
   */
  @EncryptDecryptField
  private String caseNo;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 删除标记
   */
  private Integer delFlag;

  /**
   * 状态
   */
  private Integer status;

  private Integer version;
}
