package com.beiming.odr.user.api;


import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.JudicialAssignUserDTO;
import com.beiming.odr.user.api.dto.LoginUserInfo;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AuditUserInfoReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CheckUserSearchResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

@Valid
public interface UserServiceExtendApi {

  /**
   * 查询司法确认审核用户
   *
   * @param auditUserInfoReqDTO
   * @return
   */
  DubboResult<PageInfo<CheckUserSearchResDTO>> searchCheckUser(AuditUserInfoReqDTO auditUserInfoReqDTO);

  /**
   * 查询出当前调解员 的本级案件分配员和上级机构的案件分配员
   *
   * @param userId 调解员用户Id
   * @return
   */
  DubboResult<ArrayList<JudicialAssignUserDTO>> findJudicialAssignUser(Long userId);

  /**
   * 根据用户id和角色类型获取 用户角色-机构-信息
   *
   * @param userId
   * @param roleType
   * @return
   */
  DubboResult<UserRoleInfoDTO> getRoleInfoByUserIdAndRoleCode(Long userId, RoleTypeEnum roleType);

  /**
   * 根据当前系统登录用户id获取 登录用户信息
   *
   * @param userId
   * @return
   */
  LoginUserInfo getLoginUserInfoByUserId(Long userId);

  /**
   * 根据姓名和身份证号码 查询普通用户的国籍
   *
   * @param userName 姓名
   * @param idCard   身份证号码
   * @return
   */
  DubboResult<Boolean> getNationalityByUserNameAndIdCard(String userName, String idCard);
}
