package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author 46915
 * @date 2022/12/07
 * @describes
 */
@Data
public class UserOrganizationExamine implements Serializable {

  /**
   * id
   */
  private Long id;

  /**
   * 简介
   */
  private String introduction;

  /**
   * 审核提交人
   */
  private String applyPerson;

  /**
   * 调解员，调解机构名称
   */
  private String name;

  /**
   * 操作时间
   */
  private String operateTime;

  /**
   * 审核状态（0待审核，1已通过，2已拒绝）
   */
  private Integer examineStatus;

  /**
   * 类别（调解员，调解机构）
   */
  private String type;

  /**
   * 审核拒绝原因
   */
  private String refuseReason;


  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 关联调解员，调解机构id
   */
  private Long relationId;

  /**
   * 关联调解员，调解机构父id
   */
  private Long parentRelationId;

  /**
   * 上一次修改的内容
   */
  private String lastTimeUpdateParam;
}