package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.MessageInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.MessageListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.MessageTotalDTO;
import com.github.pagehelper.PageInfo;

/**
 * 消息服务列表
 *
 * @author guming
 * @date 2024/06/18
 */
public interface MessageRemindServiceApi {

  /**
   * 添加消息
   */
  DubboResult addMessage(MessageInfoDTO reqDTO);

  /**
   * 是否有未读消息
   */
  DubboResult haveRead(MessageListReqDTO reqDTO);


  /**
   * 修改消息
   */
  DubboResult updateMessage(MessageInfoDTO reqDTO);

  /**
   * 下线消息
   */
  DubboResult offlineMessage(MessageListReqDTO dto);

  /**
   * 删除消息
   */
  DubboResult modifyMessageStatus(MessageListReqDTO dto);


  /**
   * 管理管理列表查询
   */
  DubboResult<PageInfo<MessageInfoDTO>> listManageMessage(MessageListReqDTO dto);

  /**
   * 工作人员/群众 消息列表查询
   */
  DubboResult<PageInfo<MessageInfoDTO>> listMessage(MessageListReqDTO dto);

  /**
   * 工作人员/群众 消息列表查询
   */
  DubboResult<PageInfo<MessageInfoDTO>> listUnReadMessage(MessageListReqDTO dto);

  /**
   * 工作人员/群众 消息列表查询
   */
  DubboResult<PageInfo<MessageInfoDTO>> listReadMessage(MessageListReqDTO dto);

  /**
   * 回复督办消息
   */
  DubboResult replyMessage(MessageListReqDTO dto);

  /**
   * 获取消息详情
   */
  DubboResult getMessageDetail(MessageListReqDTO dto);

  DubboResult<MessageTotalDTO> getMessageTotal(MessageListReqDTO req);
}
