package com.beiming.odr.user.api.common.enums;

public enum OrgNewTypeEnums {

  MEDIATION("调解机构"),
  ARBITRATION("仲裁机构"),

  JUDGE("法院"),
  NOTARIZATION("公证机构"),
  TRANSLATION("翻译机构"),
  EXTRATERRITORIAL("域外法查明机构"),
  EXPERT_COMMITTEE("专家委员会"),
  OTHER("其他");


  private String name;

  OrgNewTypeEnums(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }


  public static String getNameByCode(String caseType) {
    OrgNewTypeEnums[] values = OrgNewTypeEnums.values();
    for (OrgNewTypeEnums v : values) {
      if ((v.name()).equals(caseType)) {
        return v.getName();
      }
    }
    return OTHER.getName();
  }

  public static String getCodeByName(String name) {
    OrgNewTypeEnums[] values = OrgNewTypeEnums.values();
    for (OrgNewTypeEnums v : values) {
      if ((v.getName()).equals(name)) {
        return v.name();
      }
    }
    return OTHER.name();
  }

}
