package com.beiming.odr.user.api.common.enums;

import java.util.List;

/**
 * 新增的机构权限字段
 */
public enum OrgRoleTypeEnum {
  MAX_ROLE("一级-市调协会", "1"),
  SECOND_ROLE_PROFESSION("二级-行专", "2"),
  SECOND_ROLE_ORG("二级-分局", "2"),
  THIRD_ROLE_NORMAL("三级-普通机构", "3"),
  THIRD_ROLE_PROFESSION("三级-行专", "3");

  private String roleName;
  private String roleValue;

  OrgRoleTypeEnum(String roleName, String roleValue) {
    this.roleName = roleName;
    this.roleValue = roleValue;
  }

  public String getRoleName() {
    return roleName;
  }

  public String getRoleValue() {
    return roleValue;
  }

  public void setRoleName(String roleName) {
    this.roleName = roleName;
  }

  public void setRoleValue(String roleValue) {
    this.roleValue = roleValue;
  }

  /**
   * 类型的判断的方法
   */
  public static Boolean checkProgress(List<OrgRoleTypeEnum> list, String value, String operate) {
    Boolean result = false;
    for (OrgRoleTypeEnum orgRoleTypeEnum : list) {
      if ("and".equals(operate) && !orgRoleTypeEnum.name().equals(value)) { // 匹配到不相等的。
        return false;
      }
      if ("or".equals(operate) && orgRoleTypeEnum.name().equals(value)) { // 匹配到相等的。
        return true;
      }
    }
    //经过循环之后。
    if ("and".equals(operate)) {
      result = true;
    }
    return result;
  }
}
