package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @author 46915
 * @date 2022/11/27
 * @describes 公告-新闻资讯审核
 */
@Data
public class NoticeAndNewsExamineDTO implements Serializable {

  /**
   * id
   */
  private Long id;

  /**
   * 标题
   */
  private String title;

  /**
   * 公告内容
   */
  private String content;

  /**
   * 审核提交人
   */
  private String applyPerson;

  /**
   * 所属机构
   */
  private String organization;

  /**
   * 操作时间
   */
  private String operateTime;

  /**
   * 审核状态（0待审核，1已通过，2已拒绝）
   */
  private Integer examineStatus;

  /**
   * 信息类别（公告，新闻资讯）
   */
  private String informationType;

  /**
   * 审核拒绝原因
   */
  private String refuseReason;

  /**
   * 封面图地址
   */
  private String coverImgUrl;

  /**
   * 关联新闻资讯、公告id
   */
  private Long relationId;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;
}