package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.beiming.odr.user.api.dto.UserAddressInfoDTO;
import com.beiming.odr.user.api.dto.UserCertificateInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import lombok.Data;

/**
 * 机构管理员-查看服务人员信息
 */
@Data
public class SearchServicePersonResDTO implements Serializable {
  /**
   * 用户id
   */
  private Long userId;
  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  private String idCard;
  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 头像
   */
  private String headPortraitUrl;
  /**
   * 民族
   */
  private String nation;

  /**
   * 性别
   */
  private String sex;

  /**
   * 机构类型
   */
  private String mechanismType;

  /**
   * 擅长领域
   */
  private String ability;
  /**
   * 服务区代码
   */
  private String serviceAreaCode;

  /**
   * 服务区名称
   */
  private String serviceAreaName;

  /**
   * 生日
   */
  private String birthday;

  /**
   * 行政区
   */
  private String district;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 从业经历
   */
  private String experience;

  /**
   * 服务职能
   */
  private String job;

  /**
   * 从业时间
   */
  private Date employmentTime;
  
  /**
   * 从业经验
   */
  private String workExperience;
  /**
   * 工作机构
   */
  private String workOrganization;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 职业
   */
  private String occupation;

  /**
   * 毕业学校
   */
  private String graduateSchool;

  /**
   * 邮箱
   */
  private String email;


  /**
   * 用户证件集合
   */
  private List<UserCertificateInfoDTO> userCertificatesList;

  /**
   * 用户角色关系集合
   */
  private List<UserRoleInfoDTO> userRoleRelationList;

  /**
   * 用户工作地址
   */
  private List<UserAddressInfoDTO> userAddress;
  
  /**
   * 人员类型
   */
  private String personType;

  /**
   * 对外号码
   */
  private String externalPhone;
  /**
   * 工作年限
   */
  private String workYears;
  /**
   * 入职类型，
   */
  private String entryType;
  /**
   * 入职方式:
   */
  private String entryWay;
  /**
   * 是否地方财政保障或政府购买服务
   */
  private Boolean isFinancialSecurity;

  /**
   * 简介
   */
  private String introduction;

  /**
   * 是否显示机构简介 1：是 0：否
   */
  private Integer isShowIntroduction;

  /**
   * 所属机构
   */
  private String country;

  /**
   * 用户类别
   */
  private String userType;

  /**
   * 机构地址
   */
  private String orgAdress;

  /**
   * 机构id
   */
  private  Long orgId;

  private String userNameEn;

  private String userNameCn;
}
