package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationApplyAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationApplyAuditReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationApplyListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationOnlineEditReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationApplyResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import java.util.ArrayList;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface OrganizationApplyServiceApi {

  DubboResult addOrganizationApply(OrganizationApplyAddReqDTO reqDTO);

  DubboResult<OrganizationApplyResDTO> getOrganizationApply(CommonIdReqDTO idReqDTO);

  DubboResult<PageInfo<OrganizationApplyResDTO>> pageOrganizationApply(OrganizationApplyListReqDTO reqDTO);

  DubboResult audtiOrganizationApply(OrganizationApplyAuditReqDTO reqDTO);

  DubboResult editOrganizationOnline(OrganizationOnlineEditReqDTO reqDTO);

  /**
   * 根据userId查询对应的组织机构和子集组织机构
   *
   * @param userId
   * @return
   */
  DubboResult<ArrayList<OrganizationResDTO>> findOrganizationByUserId(Long userId);


  /**
   * 根据当前机构id获取 所有子集
   *
   * @param orgId
   * @param status 数据状态 0 有效 1 无效
   * @return
   */
  DubboResult<ArrayList<Long>> findAllChildrenByOrgId(Long orgId, Integer status);
}