package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;


/**
 * 后台机构新增请求参数
 */
@Data
public class OrganizationApplyAddReqDTO implements Serializable {

  /**
   * 机构代码
   */
  private Long organizationId;

  /**
   * 机构名称
   */
  private String organizationName;

  /**
   * 父级id
   */
  private Date applyTime;

  /**
   * 申请方式。在线申请：ONLINE，模板申请：TEMPLATE
   */
  private String applyMethod;

  /**
   * 审核状态(UNAUDIT:未审核,PASS:审核通过，FAIL：审核不通过)
   */
  private String auditStatus;

  /**
   * 上线状态。ONLINE / OFFLINE
   */
  private String onlineStatus;


}
