package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Data;

/**
 * @author jiangfan
 * @date 2024/05/10
 */
@Data
public class ReportCommonDTO  implements Serializable {

  private String date;

  private String num;

  private String value;

  private String percent;

  private String name;

  private String code;


  public ReportCommonDTO(String name, String num, Integer total) {
    this.setName(name);
    this.setNum(num);
    this.setPercent(div(new BigDecimal(Integer.valueOf(num == null ? "0" : num) * 100), new BigDecimal(total), 2));
  }

  public ReportCommonDTO(String name, String num, String value) {
    this.name = name;
    this.num = num;
    this.value = value;
  }

  public ReportCommonDTO() {

  }

  public ReportCommonDTO(String name, String value, String percent, String num) {
    this.name = name;
    this.value = value;
    this.percent = percent;
    this.num = num;
  }

  public ReportCommonDTO(String name,  String percent) {
    this.name = name;
    this.percent = percent;
  }


  public String div(BigDecimal v1, BigDecimal v2, int scale) {
    if (scale < 0) {
      throw new IllegalArgumentException(
          "The scale must be a positive integer or zero");
    }
    if (v2.compareTo(BigDecimal.ZERO) == 0) {
      return "0";
    }
    return v1.divide(v2, scale, RoundingMode.HALF_UP).toString();
  }
}
