package com.beiming.odr.user.api.common.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

/**
 * @Auther: 公道签名工具类
 * @Date: 2019/2/12/012 23:29
 * @Description:
 */
public class SignatureUtil {

  public static String getSignature(Map<String, String> params, String clientSecret) {
    StringBuilder origin = new StringBuilder();
    TreeMap<String, String> paramsTreeMap = new TreeMap();
    paramsTreeMap.putAll(params);
    Iterator<String> iterator = paramsTreeMap.keySet().iterator();

    while (iterator.hasNext()) {
      String key = iterator.next();
      origin.append(key).append(paramsTreeMap.get(key));
    }

    return HmacUtil.sha256HMAC(origin.toString(), clientSecret);
  }
}
