package com.beiming.odr.user.api.dto.requestdto;


import com.alibaba.fastjson.JSONArray;
import com.beiming.framework.util.StringUtils;
import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Pattern;

import com.beiming.odr.user.api.common.enums.UserSexTypeEnum;
import com.beiming.odr.user.api.common.enums.UserTypeEnums;
import lombok.Data;


/**
 * 工作人员新增参数
 */
@Data
public class BackstageUserAddReqDTO implements Serializable {

  /**
   * 用户id
   * */
  private Long userId;
  /**
   * 姓名
   */
  private String userName;


  /**
   * 账户名
   */
  private String loginName;

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "{user.phoneFormatError}")
  private String mobilePhone;

  /**
   * 证件号
   */
  /*@Pattern(regexp = UserConst.REGEX_ID_CARD, message = "{user.idCardNotIncorrect}")*/
  private String idCard;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "{user.passwordFormatError}")
  private String password;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 出生日期
   */
  private String birthday;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 职业
   */
  private String occupation;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 从业经历
   */
  private String experience;


  /** 用户地址 包括：工作地址和详细地址 */
  private JSONArray userAddress;

  /**
   * 平台职能
   */
  @NotEmpty(message = "{user.syaytemInfoNotBlank}")
  private JSONArray userRoleRelation;

  /**
   * 资格证书
   */
  private JSONArray userCertificates;
  /**
   * 对外工作电话
   */
  private String externalPhone;
  /**
   * (公安)驻所账号id
   */
  private String policeStationUserId;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 性别
   */
  private String sex;

  /**
   * 基本资料 - 职务
   */
  private String job;

  /**
   * 工作年限
   */
  private String workYears;

  /**
   * 工作机构
   */
  private String workOrganization;

  /**
   * 专兼职
   */
  private String entryType;

  /**
   * 产生方式
   */
  private String entryWay;

  /**
   * 是否地方财政保障或政府购买服务
   */
  private Boolean isFinancialSecurity;

  /**
   * 职业类型
   */
  private String profession;

  /**
   * 服务地区
   */
  private String serviceAreaName;

  /**
   * 开始工作时间
   */
  private String employmentTime;

  // 2024-05-15新增
  /**
   * 人员类型
   * 调解员、仲裁员、法官、专家、其他等
   * @see UserTypeEnums
   */
  private String userType;

  /**
   * 英文名
   */
  private String userNameEn;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 英文介绍
   */
  private String introductionEn;

  /**
   * 中文介绍
   */
  private String introduction;

  /**
   * 所属国家（仲裁员的字段）
   */
  private String country;

  /**
   * 公开状态 1 公开, 2 隐藏
   */
  private Integer show;

  /**
   * 所属机构
   */
  private Long orgId;

  /**
   * 是否暂存
   */
  private Integer temporary;

  /**
   * 是否启用
   */
  private Integer enable;

  /**
   * 创建人
   */
  private String createUser;

  public BackstageUserAddReqDTO() { };
  public BackstageUserAddReqDTO(BackstageUserImportReqDTO backstageUserImportReqDTO) {
    this.userName = backstageUserImportReqDTO.getUserName();
    this.userNameEn = backstageUserImportReqDTO.getUserNameEn();
    if (backstageUserImportReqDTO.getSex() != null) {
      this.sex = UserSexTypeEnum.getCodeByName(backstageUserImportReqDTO.getSex());
    }
    this.userType = backstageUserImportReqDTO.getUserType();
    if ("公开".equals(backstageUserImportReqDTO.getShow())) {
      this.show = 1;
    } else {
      this.show = 2;
    }
    if (backstageUserImportReqDTO.getUserType() != null) {
      this.userType = UserTypeEnums.getCodeByName(backstageUserImportReqDTO.getUserType());
    }
    this.mobilePhone = backstageUserImportReqDTO.getMobilePhone();
    this.ability = backstageUserImportReqDTO.getAbility();
    this.introduction = backstageUserImportReqDTO.getIntroduction();
    this.introductionEn = backstageUserImportReqDTO.getIntroductionEn();
    if (!StringUtils.isEmpty(backstageUserImportReqDTO.getAbility())) {
      this.ability = backstageUserImportReqDTO.getAbility().replace("、", "，");
    }
    this.enable = 0;
    this.temporary = 0;
  }

}
