package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.odr.user.api.annotation.EncryptDecryptData;
import com.beiming.odr.user.api.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 服务人员列表dto
 *
 * @author zhiguang
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class ServicePersonListResDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;
  /**
   * 用户id
   */
  private Long userId;
  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 用户名称
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 服务地区
   */
  private String serviceAreaName;

  /**
   * 服务地区
   */
  private String serviceAreaNameEn;

  /**
   * 从业时间
   */
  private Date employmentTime;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 角色名称
   */
  private String roleName;

  private String orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构地址
   */
  @EncryptDecryptField
  private String orgAddress;

  private Integer mediatorCaseNumber;

  /**
   * 手机号
   */
  @EncryptDecryptField
  private String phone;

  /**
   * 职业
   */
  private String job;

  private String status;

  private String birthday;

  @EncryptDecryptField
  private String idCard;

  private String workAddress; //工作地址

  private String experience; //工作经验或个人简介

  @EncryptDecryptField
  private String externalPhone;

  @EncryptDecryptField
  private String mobilePhone;

  private String workType; //工作类别

  private String disableTime; //禁用时间

  private String createTime; //创建时间

  /**
   * 海南国商人员类型
   * 人员类型（调解员:'MEDIATOR'、仲裁员:'ARBITRATOR'、专家:'SPECIALIST'、其他机构人员:'OTHER'
   */
  private String userType;

  /**
   * 所属国家
   */
  private String country;


  /**
   * 人员英文名
   */
  private String userNameEn;

  /**
   * 机构英文名
   */
  private String orgNameEn;


  /**
   * 角色名称英文
   */
  private String roleNameEn;

}
