package com.beiming.odr.user.api.util.sm4util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.openfeign.EncryptFeignClient;
import com.beiming.odr.user.api.dto.ParamsDto;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

/**
 * @author HUAWEI
 * @date 2022/08/23
 * @Description: 国密SM4对称加密算法，此方法需要配合 SM4_Context,SM4,Utils 共同使用
 */

@Slf4j
@Component
@SuppressWarnings("restriction")
public class SM4Utils {

  /**
   * 当时用ECB模式的时候，和前端key一致
   */
  private static final String SECRET_KEY = "DJodRR_OdR=zHSHL";
  /**
   * 当时用CBC模式的时候，和前端iv一致
   */
  private static final String IV = "ODR_SiNoSOFT=437";
  private static final String UTF_8 = "UTF-8";
  private static final boolean HEX_STRING = false;
  @Resource
  private EncryptFeignClient encryptFeignClient;

  public SM4Utils() {

  }

  /**
   * ECB模式加密
   *
   * @param plainText
   * @return
   */
  public static String encryptDataEcb(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptEcb(ctx, plainText.getBytes(StandardCharsets.UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * ECB模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataEcb(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      keyBytes = SECRET_KEY.getBytes();
      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  public static String encryptDataCbcCopy(String plainText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_ENCRYPT;

      byte[] keyBytes;
      byte[] ivBytes;

      keyBytes = SECRET_KEY.getBytes();
      ivBytes = IV.getBytes();

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyEnc(ctx, keyBytes);
      byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, plainText.getBytes(StandardCharsets.UTF_8));
      String cipherText = Base64.encodeBase64String(encrypted);
      if (cipherText != null && cipherText.trim().length() > 0) {
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(cipherText);
        cipherText = m.replaceAll("");
      }
      return cipherText;
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  /**
   * CBC模式解密
   *
   * @param cipherText
   * @return
   */
  public static String decryptDataCbcCopy(String cipherText) {
    try {
      SM4Context ctx = new SM4Context();
      ctx.isPadding = true;
      ctx.mode = SM4.SM4_DECRYPT;

      byte[] keyBytes;
      byte[] ivBytes;
      if (HEX_STRING) {
        keyBytes = Util.hexStringToBytes(SECRET_KEY);
        ivBytes = Util.hexStringToBytes(IV);
      } else {
        keyBytes = SECRET_KEY.getBytes();
        ivBytes = IV.getBytes();
      }

      SM4 sm4 = new SM4();
      sm4.sm4SetKeyDec(ctx, keyBytes);
      byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64(cipherText));
      return new String(decrypted, StandardCharsets.UTF_8);
    } catch (Exception e) {
      e.printStackTrace();
      return null;
    }
  }

  public static void main(String[] args) {
//    String source = "13888433413";
//    String target = "xy_db_encrypt_" + encryptDataCbc(source);
//    System.out.println(target);
//
    String source = "15295793474";
    String target = "xy_db_encrypt_" + encryptDataCbcCopy(source);
    System.out.println(target);

    String aa = "5+zz7+k1RuqTnFt258MeCLm18y35t83yeIYGf6FVlUc=";
    String s = decryptDataCbcCopy(aa);
    System.out.println(s);

//    String target = "meuAbpipq0K0U7ujHh3W03AzzzrDULKQ/SK5DbqdMtCfsC8qnbb/R/VKnSZPa4SSX7yfR6Y++xbCq9qvtTGR0nIKWENXrnZw5U+t+klGCEwu9YTTwIQ7qqZorQL51axbrj0p9vKZyIkUmAFap17IzAsuL2ycimUA/tW6IgPSnwA9kxOem4WKiWSTDCv99egmMqTrFV/OqnhYiGOaZSyB6XgdkuxsP3+BaO5ic2NMuoAvU4mZl85RsIZ91UKARK+B";
//
//    System.out.println(decryptDataCbc(target));
  }

  /**
   * CBC模式加密
   *
   * @param plainText
   * @return
   */
  public String encryptDataCbc(String plainText) {
    byte[] plainTextByte = plainText.getBytes(StandardCharsets.UTF_8);
    String plainTextParam = Base64Utils.encodeToString(plainTextByte);
    Map<String, String> map = new HashMap<>();
    map.put("EncData", plainTextParam);
    ParamsDto param = new ParamsDto();
    param.setObj(map);
    log.info("加密参数：{}", JSONObject.toJSONString(param));
    JSONObject encrypt = encryptFeignClient.encryption(param);
    log.info("加密结果：{}", encrypt);
    Map<String, String> data = encrypt.getObject("data", Map.class);
    String encData = data.get("EncData");
    return encData;
  }

  public String decryptDataCbc(String data) {
    ParamsDto paramsDto = new ParamsDto();
    paramsDto.getObj().put("DecryData", data);
    System.out.println("====解密参数====" + paramsDto);
    JSONObject resVo = encryptFeignClient.decryption(paramsDto);
    AssertUtils.assertTrue(1000 == resVo.getInteger("code"), APIResultCodeEnums.ILLEGAL_PARAMETER,
        "加密结果失败");
    JSONObject obj = JSON.parseObject(JSON.toJSONString(resVo.get("data")), JSONObject.class);
    String baseValue = obj.get("DecryData").toString();
    byte[] bytes = Base64Utils.decodeFromString(baseValue);
    String decryptValue = new String(bytes, StandardCharsets.UTF_8);
    return decryptValue;
  }
}
