/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.usergateway.domain.dto.responsedto;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.referee.dto.MediationCaseAgentPersonnelDTO;
import com.beiming.odr.referee.dto.MediationCasePersonnelDTO;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;
import com.beiming.odr.referee.dto.responsedto.DossAttachmentResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationActualResDTO;
import com.beiming.odr.referee.dto.responsedto.MediationListResDTO;
import com.beiming.odr.referee.enums.CaseApplyTypeEnum;
import com.beiming.odr.referee.enums.CaseProgressEnum;
import com.beiming.odr.referee.enums.CaseStatusEnum;
import com.beiming.odr.referee.enums.MediationSuccessEnum;
import com.beiming.odr.referee.util.MsgUtils;
import com.beiming.odr.user.api.common.enums.MediationTypeEnum;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.usergateway.domain.dto.ProgressDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.springframework.util.CollectionUtils;

@ApiModel(value="\u8c03\u89e3\u5217\u8868\u8fd4\u56de\u53c2\u6570")
public class MediationResponseDTO
implements Serializable {
    private static final long serialVersionUID = 7498751770270191007L;
    @ApiModelProperty(value="\u9ed8\u8ba40=\u7b7e\u540d\u5b8c\u6210-\u5168\u90e8\u540c\u610f;1=\u7b7e\u540d\u5b8c\u6210-\u6709\u4eba\u4e0d\u540c\u610f;2=\u7b7e\u540d\u5b8c\u6210-\u6240\u6709\u4eba\u4e0d\u540c\u610f;3=\u7b7e\u540d\u672a\u5b8c\u6210;")
    private String signStatus;
    private String callbackType;
    private String callbackSeq;
    @ApiModelProperty(value="\u6848\u4ef6id")
    private Long caseId;
    @ApiModelProperty(value="\u7ea0\u7eb7\u7c7b\u578b")
    private String disputeType;
    @ApiModelProperty(value="\u7ea0\u7eb7\u7c7b\u578b\u4ee3\u7801")
    private String disputeTypeCode;
    @ApiModelProperty(value="\u8c03\u89e3\u7f16\u53f7")
    private String caseNo;
    @ApiModelProperty(value="\u8c03\u89e3\u7c7b\u578b")
    private String mediationType;
    @ApiModelProperty(value="\u8c03\u89e3\u7c7b\u578b\u4ee3\u7801")
    private String mediationTypeCode;
    @ApiModelProperty(value="\u7533\u8bf7\u4eba")
    private String applicantName;
    @ApiModelProperty(value="\u7533\u8bf7\u4ebaid")
    private List<Long> applicantIds;
    @ApiModelProperty(value="\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba")
    private String applicantAgentName;
    @ApiModelProperty(value="\u7533\u8bf7\u4eba\u4ee3\u7406\u4ebaid")
    private List<Long> applicantAgentIds;
    @ApiModelProperty(value="\u88ab\u7533\u8bf7\u4eba")
    private String respondentName;
    @ApiModelProperty(value="\u88ab\u7533\u8bf7\u4ebaid")
    private List<Long> respondentIds;
    @ApiModelProperty(value="\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4eba")
    private String respondentAgentName;
    @ApiModelProperty(value="\u88ab\u7533\u8bf7\u4eba\u4ee3\u7406\u4ebaid")
    private List<Long> respondentAgentIds;
    @ApiModelProperty(value="\u7ea0\u7eb7\u63cf\u8ff0")
    private String disputeContent;
    @ApiModelProperty(value="\u7533\u8bf7\u4eba\u8bc9\u6c42")
    private String appeal;
    @ApiModelProperty(value="\u7ea0\u7eb7\u53d1\u751f\u5730")
    private String address;
    @ApiModelProperty(value="\u7ea0\u7eb7\u53d1\u751f\u5730\u4ee3\u7801")
    private String addressCode;
    @ApiModelProperty(value="\u767b\u8bb0\u65f6\u95f4")
    private String createTime;
    @ApiModelProperty(value="\u8c03\u89e3\u673a\u6784")
    private String orgName;
    @ApiModelProperty(value="\u8c03\u89e3\u673a\u6784id")
    private Long orgId;
    @ApiModelProperty(value="\u5012\u8ba1\u65f6\u5929\u6570")
    private Integer downCount;
    @ApiModelProperty(value="\u6848\u4ef6\u72b6\u6001")
    private String lawCaseStatus;
    @ApiModelProperty(value="\u9ed8\u8ba40=\u5ba1\u6279\u64cd\u4f5c\u5df2\u5b8c\u6210\uff1b1=\u5ef6\u671f\uff1b2=\u7ea0\u7eb7\u4fe1\u606f\uff1b3=\u5ef6\u671f\u53ca\u7ea0\u7eb7")
    private Integer approvalType;
    @ApiModelProperty(value="\u6848\u4ef6\u7528\u6237\u7c7b\u578b\uff08\u7533\u8bf7\u4eba ,\u88ab\u7533\u8bf7\u4eba, \u8c03\u89e3\u5458\uff09")
    private String caseUserType;
    @ApiModelProperty(value="\u8c03\u89e3\u5458\u540d\u79f0")
    private String mediator;
    @ApiModelProperty(value="\u8c03\u89e3\u5458id")
    private Long mediatorId;
    @ApiModelProperty(value="\u5f53\u524d\u8fdb\u5ea6")
    private String currentProgress;
    @ApiModelProperty(value="\u5f53\u524d\u8fdb\u5ea6\u4ee3\u7801")
    private String currentProgressCode;
    @ApiModelProperty(value="\u5f53\u524d\u6b65\u9aa4")
    private Integer currentStep;
    @ApiModelProperty(value="\u6848\u4ef6\u8fdb\u5c55\uff1aAPPLY(\u63d0\u4ea4\u7533\u8bf7), REFUSE(\u4e0d\u53d7\u7406), WAIT(\u7b49\u5f85\u8c03\u89e3), RETRACT(\u64a4\u56de\u8c03\u89e3), START(\u6b63\u5728\u8c03\u89e3), FAIL(\u8c03\u89e3\u5931\u8d25), SUCCESS(\u8c03\u89e3\u6210\u529f)")
    private List<ProgressDTO> lawCaseProgress;
    @ApiModelProperty(value="\u5f53\u524d\u8fdb\u5ea6")
    private String currentProgressSuit;
    @ApiModelProperty(value="\u5f53\u524d\u8fdb\u5ea6\u4ee3\u7801")
    private String currentProgressCodeSuit;
    @ApiModelProperty(value="\u5f53\u524d\u6b65\u9aa4")
    private Integer currentStepSuit;
    @ApiModelProperty(value="\u6848\u4ef6\u8fdb\u5c55\uff1aAPPLY(\u63d0\u4ea4\u7533\u8bf7), REFUSE(\u4e0d\u53d7\u7406), WAIT(\u7b49\u5f85\u8c03\u89e3), RETRACT(\u64a4\u56de\u8c03\u89e3), START(\u6b63\u5728\u8c03\u89e3), FAIL(\u8c03\u89e3\u5931\u8d25), SUCCESS(\u8c03\u89e3\u6210\u529f)")
    private List<ProgressDTO> lawCaseProgressSuit;
    @ApiModelProperty(value="\u6848\u4ef6\u5f55\u5165\u4eba\u7684\u89d2\u8272\u7c7b\u578b COMMON(\u666e\u901a\u7528\u6237)\u3001DISPUTE_REGISTRAR(\u7ea0\u7eb7\u767b\u8bb0\u5458)")
    private String creatorType;
    @ApiModelProperty(value="\u8c03\u89e3\u5f00\u59cb\u65f6\u95f4")
    private Long startTime;
    @ApiModelProperty(value="\u6848\u4ef6\u662f\u5426\u53ef\u64a4\u56de")
    private Boolean caseRetract;
    @ApiModelProperty(value="\u6848\u4ef6\u5f55\u5165\u4ebaID")
    private Long creatorId;
    @ApiModelProperty(value="\u4fe1\u8bbf\u4ee3\u7406\u4ebaId")
    private Long petitionAgentUserId;
    @ApiModelProperty(value="\u4fe1\u8bbf\u4ee3\u7406\u4eba\u540d\u5b57")
    private String petitionAgentUserName;
    @ApiModelProperty(value="\u662f\u5426\u5df2\u5bf9\u4fe1\u8bbf\u4ee3\u7406\u4eba\u8bc4\u4ef7")
    private Boolean petitionAgentIsEvaluate;
    @ApiModelProperty(value="\u5ef6\u671f\u539f\u56e0")
    private String extendReason;
    @ApiModelProperty(value="\u5ef6\u671f\u5929\u6570")
    private Integer extendDay;
    @ApiModelProperty(value="\u5ef6\u671f\u8868\u4e3b\u952e")
    private Long extendId;
    private String extendType;
    private String extendTypeName;
    private String extendAction;
    private String extendActionName;
    private String reasonType;
    private String reasonTypeName;
    private Boolean isSuspend;
    private Integer suspendNum;
    private Boolean hadUnreadMsg;
    @ApiModelProperty(value="\u8fc7\u671f\u63d0\u793a")
    private Boolean overTimeTips;
    @ApiModelProperty(value="\u5f15\u8c03\u6848\u4ef6\u7c7b\u578b")
    private String citeCaseType;
    @ApiModelProperty(value="\u6848\u4ef6\u6765\u6e90")
    private String origin;
    @ApiModelProperty(value="\u6848\u4ef6\u7c7b\u578b")
    private String caseType;
    @ApiModelProperty(value="\u8ddf\u6848\u4eba\u5458\u59d3\u540d")
    private String followPersonName;
    @ApiModelProperty(value="\u8ddf\u6848\u4eba\u5458\u7535\u8bdd")
    private String followPersonPhone;
    @ApiModelProperty(value="\u534f\u52a9\u8c03\u89e3\u5458")
    private ArrayList<MediationCasePersonnelDTO> mediationHelpDTOs;
    @ApiModelProperty(value="\u673a\u6784\u89d2\u8272")
    private String orgRoleType;
    private Integer simple;
    private String disputeAmount;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u53d1\u8d77\u5ef6\u671f")
    private Boolean allowExtend;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u53d1\u8d77\u5ef6\u671f\u786e\u8ba4")
    private Boolean allowExtendConfirm;
    @ApiModelProperty(value="\u673a\u6784\u662f\u5426\u5df2\u786e\u8ba4")
    private Boolean orgConfirm;
    @ApiModelProperty(value="\u6848\u4ef6\u662f\u5426\u5df2\u8bc4\u4ef7")
    private Boolean caseIsEvaluate;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u7533\u8bf7\u64a4\u8bc9 true-\u5141\u8bb8\uff1bfalse-\u4e0d\u5141\u8bb8")
    private Boolean isAllowWithdrawal;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u4e0a\u62a5")
    private Boolean allowUp = false;
    @ApiModelProperty(value="\u662f\u5426\u5141\u8bb8\u4e0b\u53d1")
    private Boolean allowDown = false;
    @ApiModelProperty(value="\u662f\u5426\u65e0\u8bc1\u636e", notes="true\u4e3a\u65e0\u8bc1\u636e")
    private Boolean noEvidenceFlag;
    @ApiModelProperty(value="\u662f\u5426\u53f7\u7801\u4e0d\u9f50", notes="true\u4e3a\u53f7\u7801\u4e0d\u9f50")
    private Boolean noAllPhoneFlag;
    @ApiModelProperty(value="\u662f\u5426\u91d1\u878d\u7c7b\u6848\u5ba1\u6279\u901a\u8fc7", notes="true\u4e3a\u901a\u8fc7 \u53ef\u53d7\u7406\u4e0d\u53d7\u7406")
    private Boolean financialApprovalFlag;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u673a\u6784\u8f6c\u79fb\u6309\u94ae")
    private Integer showTransfer;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u8f6c\u529e\u6309\u94ae")
    private Boolean showTransferBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u53d7\u7406\u6309\u94ae")
    private Boolean showAcceptBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u4e0d\u53d7\u7406(\u9000\u56de)\u6309\u94ae")
    private Boolean showNotAcceptBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u5206\u914d\u6309\u94ae")
    private Boolean showAllocationBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u91cd\u65b0\u5206\u914d\u6309\u94ae")
    private Boolean showReAllocationBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u5ef6\u671f\u7533\u8bf7\u6309\u94ae")
    private Boolean showApplyExtensionBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u5ef6\u671f\u7533\u8bf7\u4f5c\u5e9f\u6309\u94ae")
    private Boolean showRevokeApplyExtensionBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u7533\u8bf7\u91cd\u65b0\u5206\u914d\u6309\u94ae")
    private Boolean showApplyReAllocationBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u5ef6\u671f\u5ba1\u6838\u6309\u94ae")
    private Boolean showVerifyExtensionBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u7533\u8bf7\u529e\u7ed3\u6309\u94ae")
    private Boolean showApplyCompleteBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u529e\u7ed3\u5ba1\u6838\u6309\u94ae")
    private Boolean showVerifyCompleteBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u91cd\u65b0\u5206\u914d\u5ba1\u6838\u6309\u94ae")
    private Boolean showVerifyReAllocationBtn;
    @ApiModelProperty(value="\u662f\u5426\u663e\u793a\u5ef6\u671f\u7533\u8bf7\u4f5c\u5e9f\u6309\u94ae")
    private Boolean showDelayCancelBtn;
    private Integer isTurnToSw;
    private Long swCaseId;
    private String swCaseNo;
    private Date turnTime;
    private Integer matchesResult;
    private Integer intelligentReviewResult = 0;
    private List<DossAttachmentResDTO> documents;
    private String resolutionType;

    public MediationResponseDTO() {
    }

    public MediationResponseDTO(MediationListResDTO mediationListResDTO) {
        this.caseId = mediationListResDTO.getCaseId();
        this.isTurnToSw = mediationListResDTO.getIsTurnToSw();
        this.swCaseId = mediationListResDTO.getSwCaseId();
        this.swCaseNo = mediationListResDTO.getSwCaseNo();
        this.resolutionType = mediationListResDTO.getResolutionType();
        this.turnTime = mediationListResDTO.getTurnTime();
        this.disputeAmount = mediationListResDTO.getDisputeAmount();
        this.matchesResult = mediationListResDTO.getMatchesResult();
        this.intelligentReviewResult = mediationListResDTO.getIntelligentReviewResult();
        if (this.getIntelligentReviewResult() == 1) {
            this.documents = mediationListResDTO.getDocuments().stream().filter(dto -> dto.getFileName().contains("\u7ed3\u6848") || dto.getFileName().contains("\u534f\u8bae\u4e66")).collect(Collectors.toList());
        }
        this.disputeType = mediationListResDTO.getDisputeType();
        this.disputeTypeCode = mediationListResDTO.getDisputeTypeCode();
        this.caseNo = mediationListResDTO.getCaseNo();
        this.citeCaseType = mediationListResDTO.getCiteCaseType();
        this.extendId = mediationListResDTO.getExtendId();
        this.extendType = mediationListResDTO.getExtendType();
        if (StringUtils.isNotEmpty((CharSequence)mediationListResDTO.getExtendType())) {
            this.extendTypeName = ((CaseApplyTypeEnum)EnumUtils.getEnum(CaseApplyTypeEnum.class, (String)mediationListResDTO.getExtendType())).getName();
        }
        this.reasonType = mediationListResDTO.getReasonType();
        if (StringUtils.isNotEmpty((CharSequence)mediationListResDTO.getReasonType())) {
            this.reasonTypeName = ((MediationSuccessEnum)EnumUtils.getEnum(MediationSuccessEnum.class, (String)mediationListResDTO.getReasonType())).getName();
        }
        this.extendAction = mediationListResDTO.getExtendAction();
        if (StringUtils.isNotEmpty((CharSequence)mediationListResDTO.getExtendAction())) {
            this.extendActionName = ((CaseStatusEnum)EnumUtils.getEnum(CaseStatusEnum.class, (String)mediationListResDTO.getExtendAction())).getName();
        }
        this.mediationTypeCode = mediationListResDTO.getMediationType();
        this.mediationType = ((MediationTypeEnum)EnumUtils.getEnum(MediationTypeEnum.class, (String)mediationListResDTO.getMediationType())).getName();
        this.extendDay = mediationListResDTO.getExtendDay();
        this.extendReason = mediationListResDTO.getExtendReason();
        this.allowExtendConfirm = mediationListResDTO.getExtendStatus() != null && !"BOTH_CONFIRMEND".equals(mediationListResDTO.getExtendStatus()) && mediationListResDTO.getConfirmStatus() == null;
        String applicantName = "";
        StringBuilder applicantAgentName = new StringBuilder();
        ArrayList<Long> applicantIds = new ArrayList<Long>();
        ArrayList<Long> applicantAgentIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)mediationListResDTO.getApplicants())) {
            for (MediationCasePersonnelDTO mediationCasePersonnelDTO : mediationListResDTO.getApplicants()) {
                applicantName = StringUtils.isNotEmpty((CharSequence)applicantName) ? applicantName + "," + mediationCasePersonnelDTO.getName() : applicantName + mediationCasePersonnelDTO.getName();
                if (StringUtils.isNotEmpty((CharSequence)applicantAgentName.toString())) {
                    this.montageAgentName(applicantAgentName, mediationCasePersonnelDTO, ",");
                } else {
                    this.montageAgentName(applicantAgentName, mediationCasePersonnelDTO, "");
                }
                if (mediationCasePersonnelDTO.getUserId() == null) continue;
                applicantIds.add(mediationCasePersonnelDTO.getUserId());
            }
        }
        this.applicantName = applicantName;
        this.applicantAgentName = applicantAgentName.toString();
        this.applicantIds = applicantIds;
        this.applicantAgentIds = applicantAgentIds;
        String respondentName = "";
        StringBuilder respondentAgentName = new StringBuilder();
        ArrayList<Long> respondentIds = new ArrayList<Long>();
        ArrayList<Long> respondentAgentIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)mediationListResDTO.getRespondents())) {
            for (MediationCasePersonnelDTO mediationCasePersonnelDTO : mediationListResDTO.getRespondents()) {
                respondentName = StringUtils.isNotEmpty((CharSequence)respondentName) ? respondentName + (StringUtils.isEmpty((String)mediationCasePersonnelDTO.getName()) ? "" : "," + mediationCasePersonnelDTO.getName()) : respondentName + (StringUtils.isEmpty((String)mediationCasePersonnelDTO.getName()) ? "" : mediationCasePersonnelDTO.getName());
                if (StringUtils.isNotEmpty((CharSequence)respondentAgentName.toString())) {
                    this.montageAgentName(respondentAgentName, mediationCasePersonnelDTO, ",");
                } else {
                    this.montageAgentName(respondentAgentName, mediationCasePersonnelDTO, "");
                }
                if (mediationCasePersonnelDTO.getUserId() == null) continue;
                respondentIds.add(mediationCasePersonnelDTO.getUserId());
            }
        }
        this.respondentName = respondentName;
        this.respondentAgentName = respondentAgentName.toString();
        this.respondentIds = respondentIds;
        this.respondentAgentIds = respondentAgentIds;
        this.disputeContent = mediationListResDTO.getDisputeContent();
        this.appeal = mediationListResDTO.getAppeal();
        this.address = (StringUtils.isEmpty((String)mediationListResDTO.getProvName()) ? "" : mediationListResDTO.getProvName()) + (StringUtils.isEmpty((String)mediationListResDTO.getCityName()) ? "" : mediationListResDTO.getCityName()) + (StringUtils.isEmpty((String)mediationListResDTO.getAreaName()) ? "" : mediationListResDTO.getAreaName()) + (StringUtils.isEmpty((String)mediationListResDTO.getStreetName()) ? "" : mediationListResDTO.getStreetName()) + (StringUtils.isEmpty((String)mediationListResDTO.getCommunityName()) ? "" : mediationListResDTO.getCommunityName()) + (StringUtils.isEmpty((String)mediationListResDTO.getAddress()) ? "" : mediationListResDTO.getAddress());
        this.addressCode = StringUtils.isNotBlank((CharSequence)mediationListResDTO.getCommunityCode()) ? mediationListResDTO.getCommunityCode() : mediationListResDTO.getStreetCode();
        this.createTime = Java8DateUtil.formatter((Date)mediationListResDTO.getCreateTime(), (String)"yyyy-MM-dd");
        this.orgName = mediationListResDTO.getOrgName();
        this.orgId = mediationListResDTO.getOrgId();
        this.lawCaseStatus = mediationListResDTO.getLawCaseStatus();
        this.approvalType = mediationListResDTO.getApprovalType();
        this.caseUserType = mediationListResDTO.getCaseUserType();
        this.orgConfirm = mediationListResDTO.getOrgConfirm() == null ? false : mediationListResDTO.getOrgConfirm();
        this.isSuspend = mediationListResDTO.getIsSuspend() == null ? false : mediationListResDTO.getIsSuspend();
        this.suspendNum = mediationListResDTO.getSuspendNum();
        ArrayList<ProgressDTO> progress = new ArrayList<ProgressDTO>();
        if (!CollectionUtils.isEmpty((Collection)mediationListResDTO.getProgress())) {
            int i = 1;
            for (MediationCaseProgressDTO mediationCaseProgressDTO : mediationListResDTO.getProgress()) {
                ProgressDTO progressDTO;
                if (mediationCaseProgressDTO.getIsActive().booleanValue()) {
                    this.currentProgress = mediationCaseProgressDTO.getProgressName();
                    this.currentProgressCode = mediationCaseProgressDTO.getProgressCode();
                    this.currentStep = i;
                }
                if (mediationCaseProgressDTO.getIsHidden() != null && mediationCaseProgressDTO.getIsHidden().booleanValue()) continue;
                if ((CaseProgressEnum.REFUSE.name().equals(mediationCaseProgressDTO.getProgressCode()) || CaseProgressEnum.RETRACT.name().equals(mediationCaseProgressDTO.getProgressCode()) || CaseProgressEnum.FAIL.name().equals(mediationCaseProgressDTO.getProgressCode())) && mediationCaseProgressDTO.getIsActive().booleanValue()) {
                    progressDTO = new ProgressDTO(mediationCaseProgressDTO.getProgressName(), mediationCaseProgressDTO.getIsActive(), i);
                    progress.add(progressDTO);
                    break;
                }
                progressDTO = new ProgressDTO(mediationCaseProgressDTO.getProgressName(), mediationCaseProgressDTO.getIsActive(), i);
                progress.add(progressDTO);
                ++i;
            }
            this.allowExtend = mediationListResDTO.getExtendStatus() == null && !CaseProgressEnum.RETRACT.name().equals(this.currentProgressCode);
        }
        this.lawCaseProgress = progress;
        ArrayList<ProgressDTO> suitProgress = new ArrayList<ProgressDTO>();
        if (!CollectionUtils.isEmpty((Collection)mediationListResDTO.getSuitProgress())) {
            int i = 1;
            for (MediationCaseProgressDTO mediationCaseProgressDTO : mediationListResDTO.getSuitProgress()) {
                if (mediationCaseProgressDTO.getIsActive().booleanValue()) {
                    this.currentProgressSuit = mediationCaseProgressDTO.getProgressName();
                    this.currentProgressCodeSuit = mediationCaseProgressDTO.getProgressCode();
                    this.currentStepSuit = i;
                }
                if (mediationCaseProgressDTO.getIsHidden() != null && mediationCaseProgressDTO.getIsHidden().booleanValue()) continue;
                ProgressDTO progressDTO = new ProgressDTO(mediationCaseProgressDTO.getProgressName(), mediationCaseProgressDTO.getIsActive(), i);
                suitProgress.add(progressDTO);
                ++i;
            }
        }
        this.lawCaseProgressSuit = suitProgress;
        if (!CollectionUtils.isEmpty((Collection)mediationListResDTO.getMediators())) {
            this.mediator = ((MediationActualResDTO)mediationListResDTO.getMediators().get(0)).getName();
            this.mediatorId = ((MediationActualResDTO)mediationListResDTO.getMediators().get(0)).getUserId();
        }
        if (mediationListResDTO.getMediationDeadline() != null) {
            int day = (int)((mediationListResDTO.getMediationDeadline().getTime() - System.currentTimeMillis()) / 86400000L);
            this.downCount = day;
            this.overTimeTips = day < 0;
        }
        this.caseRetract = mediationListResDTO.getAllowCancel() != null && mediationListResDTO.getAllowCancel() != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.creatorId = mediationListResDTO.getCreatorId();
        this.creatorType = mediationListResDTO.getCreatorType();
        if (mediationListResDTO.getStartTime() != null) {
            this.startTime = mediationListResDTO.getStartTime().getTime();
        }
        this.petitionAgentUserId = mediationListResDTO.getPetitionAgentUserId();
        this.petitionAgentUserName = mediationListResDTO.getPetitionAgentUserName();
        this.origin = mediationListResDTO.getOrigin();
        this.caseType = mediationListResDTO.getCaseTpye();
        this.noEvidenceFlag = mediationListResDTO.getNoEvidenceFlag();
        this.noAllPhoneFlag = mediationListResDTO.getNoAllPhoneFlag();
        this.financialApprovalFlag = mediationListResDTO.getFinancialApprovalFlag();
        this.followPersonName = mediationListResDTO.getFollowPersonName();
        this.followPersonPhone = mediationListResDTO.getFollowPersonPhone();
        this.mediationHelpDTOs = mediationListResDTO.getMediationHelpDTOs();
        this.simple = mediationListResDTO.getSimple();
    }

    private void montageAgentName(StringBuilder applicantAgentName, MediationCasePersonnelDTO mediationCasePersonnelDTO, String startDot) {
        if (!CollectionUtils.isEmpty((Collection)mediationCasePersonnelDTO.getAgentList())) {
            for (int i = 0; i < mediationCasePersonnelDTO.getAgentList().size(); ++i) {
                MediationCaseAgentPersonnelDTO mediationCaseAgentPersonnelDTO = (MediationCaseAgentPersonnelDTO)mediationCasePersonnelDTO.getAgentList().get(i);
                applicantAgentName.append(StringUtils.isEmpty((String)mediationCaseAgentPersonnelDTO.getAgentName()) ? "" : (i == 0 ? startDot : ",") + mediationCaseAgentPersonnelDTO.getAgentName());
            }
        }
    }

    public String getCaseNo() {
        return MsgUtils.translateCaseNo((String)this.caseNo);
    }

    public String getSignStatus() {
        return this.signStatus;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getCallbackSeq() {
        return this.callbackSeq;
    }

    public Long getCaseId() {
        return this.caseId;
    }

    public String getDisputeType() {
        return this.disputeType;
    }

    public String getDisputeTypeCode() {
        return this.disputeTypeCode;
    }

    public String getMediationType() {
        return this.mediationType;
    }

    public String getMediationTypeCode() {
        return this.mediationTypeCode;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public List<Long> getApplicantIds() {
        return this.applicantIds;
    }

    public String getApplicantAgentName() {
        return this.applicantAgentName;
    }

    public List<Long> getApplicantAgentIds() {
        return this.applicantAgentIds;
    }

    public String getRespondentName() {
        return this.respondentName;
    }

    public List<Long> getRespondentIds() {
        return this.respondentIds;
    }

    public String getRespondentAgentName() {
        return this.respondentAgentName;
    }

    public List<Long> getRespondentAgentIds() {
        return this.respondentAgentIds;
    }

    public String getDisputeContent() {
        return this.disputeContent;
    }

    public String getAppeal() {
        return this.appeal;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddressCode() {
        return this.addressCode;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public Integer getDownCount() {
        return this.downCount;
    }

    public String getLawCaseStatus() {
        return this.lawCaseStatus;
    }

    public Integer getApprovalType() {
        return this.approvalType;
    }

    public String getCaseUserType() {
        return this.caseUserType;
    }

    public String getMediator() {
        return this.mediator;
    }

    public Long getMediatorId() {
        return this.mediatorId;
    }

    public String getCurrentProgress() {
        return this.currentProgress;
    }

    public String getCurrentProgressCode() {
        return this.currentProgressCode;
    }

    public Integer getCurrentStep() {
        return this.currentStep;
    }

    public List<ProgressDTO> getLawCaseProgress() {
        return this.lawCaseProgress;
    }

    public String getCurrentProgressSuit() {
        return this.currentProgressSuit;
    }

    public String getCurrentProgressCodeSuit() {
        return this.currentProgressCodeSuit;
    }

    public Integer getCurrentStepSuit() {
        return this.currentStepSuit;
    }

    public List<ProgressDTO> getLawCaseProgressSuit() {
        return this.lawCaseProgressSuit;
    }

    public String getCreatorType() {
        return this.creatorType;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Boolean getCaseRetract() {
        return this.caseRetract;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public Long getPetitionAgentUserId() {
        return this.petitionAgentUserId;
    }

    public String getPetitionAgentUserName() {
        return this.petitionAgentUserName;
    }

    public Boolean getPetitionAgentIsEvaluate() {
        return this.petitionAgentIsEvaluate;
    }

    public String getExtendReason() {
        return this.extendReason;
    }

    public Integer getExtendDay() {
        return this.extendDay;
    }

    public Long getExtendId() {
        return this.extendId;
    }

    public String getExtendType() {
        return this.extendType;
    }

    public String getExtendTypeName() {
        return this.extendTypeName;
    }

    public String getExtendAction() {
        return this.extendAction;
    }

    public String getExtendActionName() {
        return this.extendActionName;
    }

    public String getReasonType() {
        return this.reasonType;
    }

    public String getReasonTypeName() {
        return this.reasonTypeName;
    }

    public Boolean getIsSuspend() {
        return this.isSuspend;
    }

    public Integer getSuspendNum() {
        return this.suspendNum;
    }

    public Boolean getHadUnreadMsg() {
        return this.hadUnreadMsg;
    }

    public Boolean getOverTimeTips() {
        return this.overTimeTips;
    }

    public String getCiteCaseType() {
        return this.citeCaseType;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getCaseType() {
        return this.caseType;
    }

    public String getFollowPersonName() {
        return this.followPersonName;
    }

    public String getFollowPersonPhone() {
        return this.followPersonPhone;
    }

    public ArrayList<MediationCasePersonnelDTO> getMediationHelpDTOs() {
        return this.mediationHelpDTOs;
    }

    public String getOrgRoleType() {
        return this.orgRoleType;
    }

    public Integer getSimple() {
        return this.simple;
    }

    public String getDisputeAmount() {
        return this.disputeAmount;
    }

    public Boolean getAllowExtend() {
        return this.allowExtend;
    }

    public Boolean getAllowExtendConfirm() {
        return this.allowExtendConfirm;
    }

    public Boolean getOrgConfirm() {
        return this.orgConfirm;
    }

    public Boolean getCaseIsEvaluate() {
        return this.caseIsEvaluate;
    }

    public Boolean getIsAllowWithdrawal() {
        return this.isAllowWithdrawal;
    }

    public Boolean getAllowUp() {
        return this.allowUp;
    }

    public Boolean getAllowDown() {
        return this.allowDown;
    }

    public Boolean getNoEvidenceFlag() {
        return this.noEvidenceFlag;
    }

    public Boolean getNoAllPhoneFlag() {
        return this.noAllPhoneFlag;
    }

    public Boolean getFinancialApprovalFlag() {
        return this.financialApprovalFlag;
    }

    public Integer getShowTransfer() {
        return this.showTransfer;
    }

    public Boolean getShowTransferBtn() {
        return this.showTransferBtn;
    }

    public Boolean getShowAcceptBtn() {
        return this.showAcceptBtn;
    }

    public Boolean getShowNotAcceptBtn() {
        return this.showNotAcceptBtn;
    }

    public Boolean getShowAllocationBtn() {
        return this.showAllocationBtn;
    }

    public Boolean getShowReAllocationBtn() {
        return this.showReAllocationBtn;
    }

    public Boolean getShowApplyExtensionBtn() {
        return this.showApplyExtensionBtn;
    }

    public Boolean getShowRevokeApplyExtensionBtn() {
        return this.showRevokeApplyExtensionBtn;
    }

    public Boolean getShowApplyReAllocationBtn() {
        return this.showApplyReAllocationBtn;
    }

    public Boolean getShowVerifyExtensionBtn() {
        return this.showVerifyExtensionBtn;
    }

    public Boolean getShowApplyCompleteBtn() {
        return this.showApplyCompleteBtn;
    }

    public Boolean getShowVerifyCompleteBtn() {
        return this.showVerifyCompleteBtn;
    }

    public Boolean getShowVerifyReAllocationBtn() {
        return this.showVerifyReAllocationBtn;
    }

    public Boolean getShowDelayCancelBtn() {
        return this.showDelayCancelBtn;
    }

    public Integer getIsTurnToSw() {
        return this.isTurnToSw;
    }

    public Long getSwCaseId() {
        return this.swCaseId;
    }

    public String getSwCaseNo() {
        return this.swCaseNo;
    }

    public Date getTurnTime() {
        return this.turnTime;
    }

    public Integer getMatchesResult() {
        return this.matchesResult;
    }

    public Integer getIntelligentReviewResult() {
        return this.intelligentReviewResult;
    }

    public List<DossAttachmentResDTO> getDocuments() {
        return this.documents;
    }

    public String getResolutionType() {
        return this.resolutionType;
    }

    public void setSignStatus(String signStatus) {
        this.signStatus = signStatus;
    }

    public void setCallbackType(String callbackType) {
        this.callbackType = callbackType;
    }

    public void setCallbackSeq(String callbackSeq) {
        this.callbackSeq = callbackSeq;
    }

    public void setCaseId(Long caseId) {
        this.caseId = caseId;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }

    public void setDisputeTypeCode(String disputeTypeCode) {
        this.disputeTypeCode = disputeTypeCode;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    public void setMediationType(String mediationType) {
        this.mediationType = mediationType;
    }

    public void setMediationTypeCode(String mediationTypeCode) {
        this.mediationTypeCode = mediationTypeCode;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public void setApplicantIds(List<Long> applicantIds) {
        this.applicantIds = applicantIds;
    }

    public void setApplicantAgentName(String applicantAgentName) {
        this.applicantAgentName = applicantAgentName;
    }

    public void setApplicantAgentIds(List<Long> applicantAgentIds) {
        this.applicantAgentIds = applicantAgentIds;
    }

    public void setRespondentName(String respondentName) {
        this.respondentName = respondentName;
    }

    public void setRespondentIds(List<Long> respondentIds) {
        this.respondentIds = respondentIds;
    }

    public void setRespondentAgentName(String respondentAgentName) {
        this.respondentAgentName = respondentAgentName;
    }

    public void setRespondentAgentIds(List<Long> respondentAgentIds) {
        this.respondentAgentIds = respondentAgentIds;
    }

    public void setDisputeContent(String disputeContent) {
        this.disputeContent = disputeContent;
    }

    public void setAppeal(String appeal) {
        this.appeal = appeal;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAddressCode(String addressCode) {
        this.addressCode = addressCode;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setDownCount(Integer downCount) {
        this.downCount = downCount;
    }

    public void setLawCaseStatus(String lawCaseStatus) {
        this.lawCaseStatus = lawCaseStatus;
    }

    public void setApprovalType(Integer approvalType) {
        this.approvalType = approvalType;
    }

    public void setCaseUserType(String caseUserType) {
        this.caseUserType = caseUserType;
    }

    public void setMediator(String mediator) {
        this.mediator = mediator;
    }

    public void setMediatorId(Long mediatorId) {
        this.mediatorId = mediatorId;
    }

    public void setCurrentProgress(String currentProgress) {
        this.currentProgress = currentProgress;
    }

    public void setCurrentProgressCode(String currentProgressCode) {
        this.currentProgressCode = currentProgressCode;
    }

    public void setCurrentStep(Integer currentStep) {
        this.currentStep = currentStep;
    }

    public void setLawCaseProgress(List<ProgressDTO> lawCaseProgress) {
        this.lawCaseProgress = lawCaseProgress;
    }

    public void setCurrentProgressSuit(String currentProgressSuit) {
        this.currentProgressSuit = currentProgressSuit;
    }

    public void setCurrentProgressCodeSuit(String currentProgressCodeSuit) {
        this.currentProgressCodeSuit = currentProgressCodeSuit;
    }

    public void setCurrentStepSuit(Integer currentStepSuit) {
        this.currentStepSuit = currentStepSuit;
    }

    public void setLawCaseProgressSuit(List<ProgressDTO> lawCaseProgressSuit) {
        this.lawCaseProgressSuit = lawCaseProgressSuit;
    }

    public void setCreatorType(String creatorType) {
        this.creatorType = creatorType;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setCaseRetract(Boolean caseRetract) {
        this.caseRetract = caseRetract;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setPetitionAgentUserId(Long petitionAgentUserId) {
        this.petitionAgentUserId = petitionAgentUserId;
    }

    public void setPetitionAgentUserName(String petitionAgentUserName) {
        this.petitionAgentUserName = petitionAgentUserName;
    }

    public void setPetitionAgentIsEvaluate(Boolean petitionAgentIsEvaluate) {
        this.petitionAgentIsEvaluate = petitionAgentIsEvaluate;
    }

    public void setExtendReason(String extendReason) {
        this.extendReason = extendReason;
    }

    public void setExtendDay(Integer extendDay) {
        this.extendDay = extendDay;
    }

    public void setExtendId(Long extendId) {
        this.extendId = extendId;
    }

    public void setExtendType(String extendType) {
        this.extendType = extendType;
    }

    public void setExtendTypeName(String extendTypeName) {
        this.extendTypeName = extendTypeName;
    }

    public void setExtendAction(String extendAction) {
        this.extendAction = extendAction;
    }

    public void setExtendActionName(String extendActionName) {
        this.extendActionName = extendActionName;
    }

    public void setReasonType(String reasonType) {
        this.reasonType = reasonType;
    }

    public void setReasonTypeName(String reasonTypeName) {
        this.reasonTypeName = reasonTypeName;
    }

    public void setIsSuspend(Boolean isSuspend) {
        this.isSuspend = isSuspend;
    }

    public void setSuspendNum(Integer suspendNum) {
        this.suspendNum = suspendNum;
    }

    public void setHadUnreadMsg(Boolean hadUnreadMsg) {
        this.hadUnreadMsg = hadUnreadMsg;
    }

    public void setOverTimeTips(Boolean overTimeTips) {
        this.overTimeTips = overTimeTips;
    }

    public void setCiteCaseType(String citeCaseType) {
        this.citeCaseType = citeCaseType;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setCaseType(String caseType) {
        this.caseType = caseType;
    }

    public void setFollowPersonName(String followPersonName) {
        this.followPersonName = followPersonName;
    }

    public void setFollowPersonPhone(String followPersonPhone) {
        this.followPersonPhone = followPersonPhone;
    }

    public void setMediationHelpDTOs(ArrayList<MediationCasePersonnelDTO> mediationHelpDTOs) {
        this.mediationHelpDTOs = mediationHelpDTOs;
    }

    public void setOrgRoleType(String orgRoleType) {
        this.orgRoleType = orgRoleType;
    }

    public void setSimple(Integer simple) {
        this.simple = simple;
    }

    public void setDisputeAmount(String disputeAmount) {
        this.disputeAmount = disputeAmount;
    }

    public void setAllowExtend(Boolean allowExtend) {
        this.allowExtend = allowExtend;
    }

    public void setAllowExtendConfirm(Boolean allowExtendConfirm) {
        this.allowExtendConfirm = allowExtendConfirm;
    }

    public void setOrgConfirm(Boolean orgConfirm) {
        this.orgConfirm = orgConfirm;
    }

    public void setCaseIsEvaluate(Boolean caseIsEvaluate) {
        this.caseIsEvaluate = caseIsEvaluate;
    }

    public void setIsAllowWithdrawal(Boolean isAllowWithdrawal) {
        this.isAllowWithdrawal = isAllowWithdrawal;
    }

    public void setAllowUp(Boolean allowUp) {
        this.allowUp = allowUp;
    }

    public void setAllowDown(Boolean allowDown) {
        this.allowDown = allowDown;
    }

    public void setNoEvidenceFlag(Boolean noEvidenceFlag) {
        this.noEvidenceFlag = noEvidenceFlag;
    }

    public void setNoAllPhoneFlag(Boolean noAllPhoneFlag) {
        this.noAllPhoneFlag = noAllPhoneFlag;
    }

    public void setFinancialApprovalFlag(Boolean financialApprovalFlag) {
        this.financialApprovalFlag = financialApprovalFlag;
    }

    public void setShowTransfer(Integer showTransfer) {
        this.showTransfer = showTransfer;
    }

    public void setShowTransferBtn(Boolean showTransferBtn) {
        this.showTransferBtn = showTransferBtn;
    }

    public void setShowAcceptBtn(Boolean showAcceptBtn) {
        this.showAcceptBtn = showAcceptBtn;
    }

    public void setShowNotAcceptBtn(Boolean showNotAcceptBtn) {
        this.showNotAcceptBtn = showNotAcceptBtn;
    }

    public void setShowAllocationBtn(Boolean showAllocationBtn) {
        this.showAllocationBtn = showAllocationBtn;
    }

    public void setShowReAllocationBtn(Boolean showReAllocationBtn) {
        this.showReAllocationBtn = showReAllocationBtn;
    }

    public void setShowApplyExtensionBtn(Boolean showApplyExtensionBtn) {
        this.showApplyExtensionBtn = showApplyExtensionBtn;
    }

    public void setShowRevokeApplyExtensionBtn(Boolean showRevokeApplyExtensionBtn) {
        this.showRevokeApplyExtensionBtn = showRevokeApplyExtensionBtn;
    }

    public void setShowApplyReAllocationBtn(Boolean showApplyReAllocationBtn) {
        this.showApplyReAllocationBtn = showApplyReAllocationBtn;
    }

    public void setShowVerifyExtensionBtn(Boolean showVerifyExtensionBtn) {
        this.showVerifyExtensionBtn = showVerifyExtensionBtn;
    }

    public void setShowApplyCompleteBtn(Boolean showApplyCompleteBtn) {
        this.showApplyCompleteBtn = showApplyCompleteBtn;
    }

    public void setShowVerifyCompleteBtn(Boolean showVerifyCompleteBtn) {
        this.showVerifyCompleteBtn = showVerifyCompleteBtn;
    }

    public void setShowVerifyReAllocationBtn(Boolean showVerifyReAllocationBtn) {
        this.showVerifyReAllocationBtn = showVerifyReAllocationBtn;
    }

    public void setShowDelayCancelBtn(Boolean showDelayCancelBtn) {
        this.showDelayCancelBtn = showDelayCancelBtn;
    }

    public void setIsTurnToSw(Integer isTurnToSw) {
        this.isTurnToSw = isTurnToSw;
    }

    public void setSwCaseId(Long swCaseId) {
        this.swCaseId = swCaseId;
    }

    public void setSwCaseNo(String swCaseNo) {
        this.swCaseNo = swCaseNo;
    }

    public void setTurnTime(Date turnTime) {
        this.turnTime = turnTime;
    }

    public void setMatchesResult(Integer matchesResult) {
        this.matchesResult = matchesResult;
    }

    public void setIntelligentReviewResult(Integer intelligentReviewResult) {
        this.intelligentReviewResult = intelligentReviewResult;
    }

    public void setDocuments(List<DossAttachmentResDTO> documents) {
        this.documents = documents;
    }

    public void setResolutionType(String resolutionType) {
        this.resolutionType = resolutionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediationResponseDTO)) {
            return false;
        }
        MediationResponseDTO other = (MediationResponseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signStatus = this.getSignStatus();
        String other$signStatus = other.getSignStatus();
        if (this$signStatus == null ? other$signStatus != null : !this$signStatus.equals(other$signStatus)) {
            return false;
        }
        String this$callbackType = this.getCallbackType();
        String other$callbackType = other.getCallbackType();
        if (this$callbackType == null ? other$callbackType != null : !this$callbackType.equals(other$callbackType)) {
            return false;
        }
        String this$callbackSeq = this.getCallbackSeq();
        String other$callbackSeq = other.getCallbackSeq();
        if (this$callbackSeq == null ? other$callbackSeq != null : !this$callbackSeq.equals(other$callbackSeq)) {
            return false;
        }
        Long this$caseId = this.getCaseId();
        Long other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !((Object)this$caseId).equals(other$caseId)) {
            return false;
        }
        String this$disputeType = this.getDisputeType();
        String other$disputeType = other.getDisputeType();
        if (this$disputeType == null ? other$disputeType != null : !this$disputeType.equals(other$disputeType)) {
            return false;
        }
        String this$disputeTypeCode = this.getDisputeTypeCode();
        String other$disputeTypeCode = other.getDisputeTypeCode();
        if (this$disputeTypeCode == null ? other$disputeTypeCode != null : !this$disputeTypeCode.equals(other$disputeTypeCode)) {
            return false;
        }
        String this$caseNo = this.getCaseNo();
        String other$caseNo = other.getCaseNo();
        if (this$caseNo == null ? other$caseNo != null : !this$caseNo.equals(other$caseNo)) {
            return false;
        }
        String this$mediationType = this.getMediationType();
        String other$mediationType = other.getMediationType();
        if (this$mediationType == null ? other$mediationType != null : !this$mediationType.equals(other$mediationType)) {
            return false;
        }
        String this$mediationTypeCode = this.getMediationTypeCode();
        String other$mediationTypeCode = other.getMediationTypeCode();
        if (this$mediationTypeCode == null ? other$mediationTypeCode != null : !this$mediationTypeCode.equals(other$mediationTypeCode)) {
            return false;
        }
        String this$applicantName = this.getApplicantName();
        String other$applicantName = other.getApplicantName();
        if (this$applicantName == null ? other$applicantName != null : !this$applicantName.equals(other$applicantName)) {
            return false;
        }
        List<Long> this$applicantIds = this.getApplicantIds();
        List<Long> other$applicantIds = other.getApplicantIds();
        if (this$applicantIds == null ? other$applicantIds != null : !((Object)this$applicantIds).equals(other$applicantIds)) {
            return false;
        }
        String this$applicantAgentName = this.getApplicantAgentName();
        String other$applicantAgentName = other.getApplicantAgentName();
        if (this$applicantAgentName == null ? other$applicantAgentName != null : !this$applicantAgentName.equals(other$applicantAgentName)) {
            return false;
        }
        List<Long> this$applicantAgentIds = this.getApplicantAgentIds();
        List<Long> other$applicantAgentIds = other.getApplicantAgentIds();
        if (this$applicantAgentIds == null ? other$applicantAgentIds != null : !((Object)this$applicantAgentIds).equals(other$applicantAgentIds)) {
            return false;
        }
        String this$respondentName = this.getRespondentName();
        String other$respondentName = other.getRespondentName();
        if (this$respondentName == null ? other$respondentName != null : !this$respondentName.equals(other$respondentName)) {
            return false;
        }
        List<Long> this$respondentIds = this.getRespondentIds();
        List<Long> other$respondentIds = other.getRespondentIds();
        if (this$respondentIds == null ? other$respondentIds != null : !((Object)this$respondentIds).equals(other$respondentIds)) {
            return false;
        }
        String this$respondentAgentName = this.getRespondentAgentName();
        String other$respondentAgentName = other.getRespondentAgentName();
        if (this$respondentAgentName == null ? other$respondentAgentName != null : !this$respondentAgentName.equals(other$respondentAgentName)) {
            return false;
        }
        List<Long> this$respondentAgentIds = this.getRespondentAgentIds();
        List<Long> other$respondentAgentIds = other.getRespondentAgentIds();
        if (this$respondentAgentIds == null ? other$respondentAgentIds != null : !((Object)this$respondentAgentIds).equals(other$respondentAgentIds)) {
            return false;
        }
        String this$disputeContent = this.getDisputeContent();
        String other$disputeContent = other.getDisputeContent();
        if (this$disputeContent == null ? other$disputeContent != null : !this$disputeContent.equals(other$disputeContent)) {
            return false;
        }
        String this$appeal = this.getAppeal();
        String other$appeal = other.getAppeal();
        if (this$appeal == null ? other$appeal != null : !this$appeal.equals(other$appeal)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$addressCode = this.getAddressCode();
        String other$addressCode = other.getAddressCode();
        if (this$addressCode == null ? other$addressCode != null : !this$addressCode.equals(other$addressCode)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$orgName = this.getOrgName();
        String other$orgName = other.getOrgName();
        if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        Integer this$downCount = this.getDownCount();
        Integer other$downCount = other.getDownCount();
        if (this$downCount == null ? other$downCount != null : !((Object)this$downCount).equals(other$downCount)) {
            return false;
        }
        String this$lawCaseStatus = this.getLawCaseStatus();
        String other$lawCaseStatus = other.getLawCaseStatus();
        if (this$lawCaseStatus == null ? other$lawCaseStatus != null : !this$lawCaseStatus.equals(other$lawCaseStatus)) {
            return false;
        }
        Integer this$approvalType = this.getApprovalType();
        Integer other$approvalType = other.getApprovalType();
        if (this$approvalType == null ? other$approvalType != null : !((Object)this$approvalType).equals(other$approvalType)) {
            return false;
        }
        String this$caseUserType = this.getCaseUserType();
        String other$caseUserType = other.getCaseUserType();
        if (this$caseUserType == null ? other$caseUserType != null : !this$caseUserType.equals(other$caseUserType)) {
            return false;
        }
        String this$mediator = this.getMediator();
        String other$mediator = other.getMediator();
        if (this$mediator == null ? other$mediator != null : !this$mediator.equals(other$mediator)) {
            return false;
        }
        Long this$mediatorId = this.getMediatorId();
        Long other$mediatorId = other.getMediatorId();
        if (this$mediatorId == null ? other$mediatorId != null : !((Object)this$mediatorId).equals(other$mediatorId)) {
            return false;
        }
        String this$currentProgress = this.getCurrentProgress();
        String other$currentProgress = other.getCurrentProgress();
        if (this$currentProgress == null ? other$currentProgress != null : !this$currentProgress.equals(other$currentProgress)) {
            return false;
        }
        String this$currentProgressCode = this.getCurrentProgressCode();
        String other$currentProgressCode = other.getCurrentProgressCode();
        if (this$currentProgressCode == null ? other$currentProgressCode != null : !this$currentProgressCode.equals(other$currentProgressCode)) {
            return false;
        }
        Integer this$currentStep = this.getCurrentStep();
        Integer other$currentStep = other.getCurrentStep();
        if (this$currentStep == null ? other$currentStep != null : !((Object)this$currentStep).equals(other$currentStep)) {
            return false;
        }
        List<ProgressDTO> this$lawCaseProgress = this.getLawCaseProgress();
        List<ProgressDTO> other$lawCaseProgress = other.getLawCaseProgress();
        if (this$lawCaseProgress == null ? other$lawCaseProgress != null : !((Object)this$lawCaseProgress).equals(other$lawCaseProgress)) {
            return false;
        }
        String this$currentProgressSuit = this.getCurrentProgressSuit();
        String other$currentProgressSuit = other.getCurrentProgressSuit();
        if (this$currentProgressSuit == null ? other$currentProgressSuit != null : !this$currentProgressSuit.equals(other$currentProgressSuit)) {
            return false;
        }
        String this$currentProgressCodeSuit = this.getCurrentProgressCodeSuit();
        String other$currentProgressCodeSuit = other.getCurrentProgressCodeSuit();
        if (this$currentProgressCodeSuit == null ? other$currentProgressCodeSuit != null : !this$currentProgressCodeSuit.equals(other$currentProgressCodeSuit)) {
            return false;
        }
        Integer this$currentStepSuit = this.getCurrentStepSuit();
        Integer other$currentStepSuit = other.getCurrentStepSuit();
        if (this$currentStepSuit == null ? other$currentStepSuit != null : !((Object)this$currentStepSuit).equals(other$currentStepSuit)) {
            return false;
        }
        List<ProgressDTO> this$lawCaseProgressSuit = this.getLawCaseProgressSuit();
        List<ProgressDTO> other$lawCaseProgressSuit = other.getLawCaseProgressSuit();
        if (this$lawCaseProgressSuit == null ? other$lawCaseProgressSuit != null : !((Object)this$lawCaseProgressSuit).equals(other$lawCaseProgressSuit)) {
            return false;
        }
        String this$creatorType = this.getCreatorType();
        String other$creatorType = other.getCreatorType();
        if (this$creatorType == null ? other$creatorType != null : !this$creatorType.equals(other$creatorType)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Boolean this$caseRetract = this.getCaseRetract();
        Boolean other$caseRetract = other.getCaseRetract();
        if (this$caseRetract == null ? other$caseRetract != null : !((Object)this$caseRetract).equals(other$caseRetract)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        Long this$petitionAgentUserId = this.getPetitionAgentUserId();
        Long other$petitionAgentUserId = other.getPetitionAgentUserId();
        if (this$petitionAgentUserId == null ? other$petitionAgentUserId != null : !((Object)this$petitionAgentUserId).equals(other$petitionAgentUserId)) {
            return false;
        }
        String this$petitionAgentUserName = this.getPetitionAgentUserName();
        String other$petitionAgentUserName = other.getPetitionAgentUserName();
        if (this$petitionAgentUserName == null ? other$petitionAgentUserName != null : !this$petitionAgentUserName.equals(other$petitionAgentUserName)) {
            return false;
        }
        Boolean this$petitionAgentIsEvaluate = this.getPetitionAgentIsEvaluate();
        Boolean other$petitionAgentIsEvaluate = other.getPetitionAgentIsEvaluate();
        if (this$petitionAgentIsEvaluate == null ? other$petitionAgentIsEvaluate != null : !((Object)this$petitionAgentIsEvaluate).equals(other$petitionAgentIsEvaluate)) {
            return false;
        }
        String this$extendReason = this.getExtendReason();
        String other$extendReason = other.getExtendReason();
        if (this$extendReason == null ? other$extendReason != null : !this$extendReason.equals(other$extendReason)) {
            return false;
        }
        Integer this$extendDay = this.getExtendDay();
        Integer other$extendDay = other.getExtendDay();
        if (this$extendDay == null ? other$extendDay != null : !((Object)this$extendDay).equals(other$extendDay)) {
            return false;
        }
        Long this$extendId = this.getExtendId();
        Long other$extendId = other.getExtendId();
        if (this$extendId == null ? other$extendId != null : !((Object)this$extendId).equals(other$extendId)) {
            return false;
        }
        String this$extendType = this.getExtendType();
        String other$extendType = other.getExtendType();
        if (this$extendType == null ? other$extendType != null : !this$extendType.equals(other$extendType)) {
            return false;
        }
        String this$extendTypeName = this.getExtendTypeName();
        String other$extendTypeName = other.getExtendTypeName();
        if (this$extendTypeName == null ? other$extendTypeName != null : !this$extendTypeName.equals(other$extendTypeName)) {
            return false;
        }
        String this$extendAction = this.getExtendAction();
        String other$extendAction = other.getExtendAction();
        if (this$extendAction == null ? other$extendAction != null : !this$extendAction.equals(other$extendAction)) {
            return false;
        }
        String this$extendActionName = this.getExtendActionName();
        String other$extendActionName = other.getExtendActionName();
        if (this$extendActionName == null ? other$extendActionName != null : !this$extendActionName.equals(other$extendActionName)) {
            return false;
        }
        String this$reasonType = this.getReasonType();
        String other$reasonType = other.getReasonType();
        if (this$reasonType == null ? other$reasonType != null : !this$reasonType.equals(other$reasonType)) {
            return false;
        }
        String this$reasonTypeName = this.getReasonTypeName();
        String other$reasonTypeName = other.getReasonTypeName();
        if (this$reasonTypeName == null ? other$reasonTypeName != null : !this$reasonTypeName.equals(other$reasonTypeName)) {
            return false;
        }
        Boolean this$isSuspend = this.getIsSuspend();
        Boolean other$isSuspend = other.getIsSuspend();
        if (this$isSuspend == null ? other$isSuspend != null : !((Object)this$isSuspend).equals(other$isSuspend)) {
            return false;
        }
        Integer this$suspendNum = this.getSuspendNum();
        Integer other$suspendNum = other.getSuspendNum();
        if (this$suspendNum == null ? other$suspendNum != null : !((Object)this$suspendNum).equals(other$suspendNum)) {
            return false;
        }
        Boolean this$hadUnreadMsg = this.getHadUnreadMsg();
        Boolean other$hadUnreadMsg = other.getHadUnreadMsg();
        if (this$hadUnreadMsg == null ? other$hadUnreadMsg != null : !((Object)this$hadUnreadMsg).equals(other$hadUnreadMsg)) {
            return false;
        }
        Boolean this$overTimeTips = this.getOverTimeTips();
        Boolean other$overTimeTips = other.getOverTimeTips();
        if (this$overTimeTips == null ? other$overTimeTips != null : !((Object)this$overTimeTips).equals(other$overTimeTips)) {
            return false;
        }
        String this$citeCaseType = this.getCiteCaseType();
        String other$citeCaseType = other.getCiteCaseType();
        if (this$citeCaseType == null ? other$citeCaseType != null : !this$citeCaseType.equals(other$citeCaseType)) {
            return false;
        }
        String this$origin = this.getOrigin();
        String other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        String this$caseType = this.getCaseType();
        String other$caseType = other.getCaseType();
        if (this$caseType == null ? other$caseType != null : !this$caseType.equals(other$caseType)) {
            return false;
        }
        String this$followPersonName = this.getFollowPersonName();
        String other$followPersonName = other.getFollowPersonName();
        if (this$followPersonName == null ? other$followPersonName != null : !this$followPersonName.equals(other$followPersonName)) {
            return false;
        }
        String this$followPersonPhone = this.getFollowPersonPhone();
        String other$followPersonPhone = other.getFollowPersonPhone();
        if (this$followPersonPhone == null ? other$followPersonPhone != null : !this$followPersonPhone.equals(other$followPersonPhone)) {
            return false;
        }
        ArrayList<MediationCasePersonnelDTO> this$mediationHelpDTOs = this.getMediationHelpDTOs();
        ArrayList<MediationCasePersonnelDTO> other$mediationHelpDTOs = other.getMediationHelpDTOs();
        if (this$mediationHelpDTOs == null ? other$mediationHelpDTOs != null : !((Object)this$mediationHelpDTOs).equals(other$mediationHelpDTOs)) {
            return false;
        }
        String this$orgRoleType = this.getOrgRoleType();
        String other$orgRoleType = other.getOrgRoleType();
        if (this$orgRoleType == null ? other$orgRoleType != null : !this$orgRoleType.equals(other$orgRoleType)) {
            return false;
        }
        Integer this$simple = this.getSimple();
        Integer other$simple = other.getSimple();
        if (this$simple == null ? other$simple != null : !((Object)this$simple).equals(other$simple)) {
            return false;
        }
        String this$disputeAmount = this.getDisputeAmount();
        String other$disputeAmount = other.getDisputeAmount();
        if (this$disputeAmount == null ? other$disputeAmount != null : !this$disputeAmount.equals(other$disputeAmount)) {
            return false;
        }
        Boolean this$allowExtend = this.getAllowExtend();
        Boolean other$allowExtend = other.getAllowExtend();
        if (this$allowExtend == null ? other$allowExtend != null : !((Object)this$allowExtend).equals(other$allowExtend)) {
            return false;
        }
        Boolean this$allowExtendConfirm = this.getAllowExtendConfirm();
        Boolean other$allowExtendConfirm = other.getAllowExtendConfirm();
        if (this$allowExtendConfirm == null ? other$allowExtendConfirm != null : !((Object)this$allowExtendConfirm).equals(other$allowExtendConfirm)) {
            return false;
        }
        Boolean this$orgConfirm = this.getOrgConfirm();
        Boolean other$orgConfirm = other.getOrgConfirm();
        if (this$orgConfirm == null ? other$orgConfirm != null : !((Object)this$orgConfirm).equals(other$orgConfirm)) {
            return false;
        }
        Boolean this$caseIsEvaluate = this.getCaseIsEvaluate();
        Boolean other$caseIsEvaluate = other.getCaseIsEvaluate();
        if (this$caseIsEvaluate == null ? other$caseIsEvaluate != null : !((Object)this$caseIsEvaluate).equals(other$caseIsEvaluate)) {
            return false;
        }
        Boolean this$isAllowWithdrawal = this.getIsAllowWithdrawal();
        Boolean other$isAllowWithdrawal = other.getIsAllowWithdrawal();
        if (this$isAllowWithdrawal == null ? other$isAllowWithdrawal != null : !((Object)this$isAllowWithdrawal).equals(other$isAllowWithdrawal)) {
            return false;
        }
        Boolean this$allowUp = this.getAllowUp();
        Boolean other$allowUp = other.getAllowUp();
        if (this$allowUp == null ? other$allowUp != null : !((Object)this$allowUp).equals(other$allowUp)) {
            return false;
        }
        Boolean this$allowDown = this.getAllowDown();
        Boolean other$allowDown = other.getAllowDown();
        if (this$allowDown == null ? other$allowDown != null : !((Object)this$allowDown).equals(other$allowDown)) {
            return false;
        }
        Boolean this$noEvidenceFlag = this.getNoEvidenceFlag();
        Boolean other$noEvidenceFlag = other.getNoEvidenceFlag();
        if (this$noEvidenceFlag == null ? other$noEvidenceFlag != null : !((Object)this$noEvidenceFlag).equals(other$noEvidenceFlag)) {
            return false;
        }
        Boolean this$noAllPhoneFlag = this.getNoAllPhoneFlag();
        Boolean other$noAllPhoneFlag = other.getNoAllPhoneFlag();
        if (this$noAllPhoneFlag == null ? other$noAllPhoneFlag != null : !((Object)this$noAllPhoneFlag).equals(other$noAllPhoneFlag)) {
            return false;
        }
        Boolean this$financialApprovalFlag = this.getFinancialApprovalFlag();
        Boolean other$financialApprovalFlag = other.getFinancialApprovalFlag();
        if (this$financialApprovalFlag == null ? other$financialApprovalFlag != null : !((Object)this$financialApprovalFlag).equals(other$financialApprovalFlag)) {
            return false;
        }
        Integer this$showTransfer = this.getShowTransfer();
        Integer other$showTransfer = other.getShowTransfer();
        if (this$showTransfer == null ? other$showTransfer != null : !((Object)this$showTransfer).equals(other$showTransfer)) {
            return false;
        }
        Boolean this$showTransferBtn = this.getShowTransferBtn();
        Boolean other$showTransferBtn = other.getShowTransferBtn();
        if (this$showTransferBtn == null ? other$showTransferBtn != null : !((Object)this$showTransferBtn).equals(other$showTransferBtn)) {
            return false;
        }
        Boolean this$showAcceptBtn = this.getShowAcceptBtn();
        Boolean other$showAcceptBtn = other.getShowAcceptBtn();
        if (this$showAcceptBtn == null ? other$showAcceptBtn != null : !((Object)this$showAcceptBtn).equals(other$showAcceptBtn)) {
            return false;
        }
        Boolean this$showNotAcceptBtn = this.getShowNotAcceptBtn();
        Boolean other$showNotAcceptBtn = other.getShowNotAcceptBtn();
        if (this$showNotAcceptBtn == null ? other$showNotAcceptBtn != null : !((Object)this$showNotAcceptBtn).equals(other$showNotAcceptBtn)) {
            return false;
        }
        Boolean this$showAllocationBtn = this.getShowAllocationBtn();
        Boolean other$showAllocationBtn = other.getShowAllocationBtn();
        if (this$showAllocationBtn == null ? other$showAllocationBtn != null : !((Object)this$showAllocationBtn).equals(other$showAllocationBtn)) {
            return false;
        }
        Boolean this$showReAllocationBtn = this.getShowReAllocationBtn();
        Boolean other$showReAllocationBtn = other.getShowReAllocationBtn();
        if (this$showReAllocationBtn == null ? other$showReAllocationBtn != null : !((Object)this$showReAllocationBtn).equals(other$showReAllocationBtn)) {
            return false;
        }
        Boolean this$showApplyExtensionBtn = this.getShowApplyExtensionBtn();
        Boolean other$showApplyExtensionBtn = other.getShowApplyExtensionBtn();
        if (this$showApplyExtensionBtn == null ? other$showApplyExtensionBtn != null : !((Object)this$showApplyExtensionBtn).equals(other$showApplyExtensionBtn)) {
            return false;
        }
        Boolean this$showRevokeApplyExtensionBtn = this.getShowRevokeApplyExtensionBtn();
        Boolean other$showRevokeApplyExtensionBtn = other.getShowRevokeApplyExtensionBtn();
        if (this$showRevokeApplyExtensionBtn == null ? other$showRevokeApplyExtensionBtn != null : !((Object)this$showRevokeApplyExtensionBtn).equals(other$showRevokeApplyExtensionBtn)) {
            return false;
        }
        Boolean this$showApplyReAllocationBtn = this.getShowApplyReAllocationBtn();
        Boolean other$showApplyReAllocationBtn = other.getShowApplyReAllocationBtn();
        if (this$showApplyReAllocationBtn == null ? other$showApplyReAllocationBtn != null : !((Object)this$showApplyReAllocationBtn).equals(other$showApplyReAllocationBtn)) {
            return false;
        }
        Boolean this$showVerifyExtensionBtn = this.getShowVerifyExtensionBtn();
        Boolean other$showVerifyExtensionBtn = other.getShowVerifyExtensionBtn();
        if (this$showVerifyExtensionBtn == null ? other$showVerifyExtensionBtn != null : !((Object)this$showVerifyExtensionBtn).equals(other$showVerifyExtensionBtn)) {
            return false;
        }
        Boolean this$showApplyCompleteBtn = this.getShowApplyCompleteBtn();
        Boolean other$showApplyCompleteBtn = other.getShowApplyCompleteBtn();
        if (this$showApplyCompleteBtn == null ? other$showApplyCompleteBtn != null : !((Object)this$showApplyCompleteBtn).equals(other$showApplyCompleteBtn)) {
            return false;
        }
        Boolean this$showVerifyCompleteBtn = this.getShowVerifyCompleteBtn();
        Boolean other$showVerifyCompleteBtn = other.getShowVerifyCompleteBtn();
        if (this$showVerifyCompleteBtn == null ? other$showVerifyCompleteBtn != null : !((Object)this$showVerifyCompleteBtn).equals(other$showVerifyCompleteBtn)) {
            return false;
        }
        Boolean this$showVerifyReAllocationBtn = this.getShowVerifyReAllocationBtn();
        Boolean other$showVerifyReAllocationBtn = other.getShowVerifyReAllocationBtn();
        if (this$showVerifyReAllocationBtn == null ? other$showVerifyReAllocationBtn != null : !((Object)this$showVerifyReAllocationBtn).equals(other$showVerifyReAllocationBtn)) {
            return false;
        }
        Boolean this$showDelayCancelBtn = this.getShowDelayCancelBtn();
        Boolean other$showDelayCancelBtn = other.getShowDelayCancelBtn();
        if (this$showDelayCancelBtn == null ? other$showDelayCancelBtn != null : !((Object)this$showDelayCancelBtn).equals(other$showDelayCancelBtn)) {
            return false;
        }
        Integer this$isTurnToSw = this.getIsTurnToSw();
        Integer other$isTurnToSw = other.getIsTurnToSw();
        if (this$isTurnToSw == null ? other$isTurnToSw != null : !((Object)this$isTurnToSw).equals(other$isTurnToSw)) {
            return false;
        }
        Long this$swCaseId = this.getSwCaseId();
        Long other$swCaseId = other.getSwCaseId();
        if (this$swCaseId == null ? other$swCaseId != null : !((Object)this$swCaseId).equals(other$swCaseId)) {
            return false;
        }
        String this$swCaseNo = this.getSwCaseNo();
        String other$swCaseNo = other.getSwCaseNo();
        if (this$swCaseNo == null ? other$swCaseNo != null : !this$swCaseNo.equals(other$swCaseNo)) {
            return false;
        }
        Date this$turnTime = this.getTurnTime();
        Date other$turnTime = other.getTurnTime();
        if (this$turnTime == null ? other$turnTime != null : !((Object)this$turnTime).equals(other$turnTime)) {
            return false;
        }
        Integer this$matchesResult = this.getMatchesResult();
        Integer other$matchesResult = other.getMatchesResult();
        if (this$matchesResult == null ? other$matchesResult != null : !((Object)this$matchesResult).equals(other$matchesResult)) {
            return false;
        }
        Integer this$intelligentReviewResult = this.getIntelligentReviewResult();
        Integer other$intelligentReviewResult = other.getIntelligentReviewResult();
        if (this$intelligentReviewResult == null ? other$intelligentReviewResult != null : !((Object)this$intelligentReviewResult).equals(other$intelligentReviewResult)) {
            return false;
        }
        List<DossAttachmentResDTO> this$documents = this.getDocuments();
        List<DossAttachmentResDTO> other$documents = other.getDocuments();
        if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
            return false;
        }
        String this$resolutionType = this.getResolutionType();
        String other$resolutionType = other.getResolutionType();
        return !(this$resolutionType == null ? other$resolutionType != null : !this$resolutionType.equals(other$resolutionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MediationResponseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signStatus = this.getSignStatus();
        result = result * 59 + ($signStatus == null ? 43 : $signStatus.hashCode());
        String $callbackType = this.getCallbackType();
        result = result * 59 + ($callbackType == null ? 43 : $callbackType.hashCode());
        String $callbackSeq = this.getCallbackSeq();
        result = result * 59 + ($callbackSeq == null ? 43 : $callbackSeq.hashCode());
        Long $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 43 : ((Object)$caseId).hashCode());
        String $disputeType = this.getDisputeType();
        result = result * 59 + ($disputeType == null ? 43 : $disputeType.hashCode());
        String $disputeTypeCode = this.getDisputeTypeCode();
        result = result * 59 + ($disputeTypeCode == null ? 43 : $disputeTypeCode.hashCode());
        String $caseNo = this.getCaseNo();
        result = result * 59 + ($caseNo == null ? 43 : $caseNo.hashCode());
        String $mediationType = this.getMediationType();
        result = result * 59 + ($mediationType == null ? 43 : $mediationType.hashCode());
        String $mediationTypeCode = this.getMediationTypeCode();
        result = result * 59 + ($mediationTypeCode == null ? 43 : $mediationTypeCode.hashCode());
        String $applicantName = this.getApplicantName();
        result = result * 59 + ($applicantName == null ? 43 : $applicantName.hashCode());
        List<Long> $applicantIds = this.getApplicantIds();
        result = result * 59 + ($applicantIds == null ? 43 : ((Object)$applicantIds).hashCode());
        String $applicantAgentName = this.getApplicantAgentName();
        result = result * 59 + ($applicantAgentName == null ? 43 : $applicantAgentName.hashCode());
        List<Long> $applicantAgentIds = this.getApplicantAgentIds();
        result = result * 59 + ($applicantAgentIds == null ? 43 : ((Object)$applicantAgentIds).hashCode());
        String $respondentName = this.getRespondentName();
        result = result * 59 + ($respondentName == null ? 43 : $respondentName.hashCode());
        List<Long> $respondentIds = this.getRespondentIds();
        result = result * 59 + ($respondentIds == null ? 43 : ((Object)$respondentIds).hashCode());
        String $respondentAgentName = this.getRespondentAgentName();
        result = result * 59 + ($respondentAgentName == null ? 43 : $respondentAgentName.hashCode());
        List<Long> $respondentAgentIds = this.getRespondentAgentIds();
        result = result * 59 + ($respondentAgentIds == null ? 43 : ((Object)$respondentAgentIds).hashCode());
        String $disputeContent = this.getDisputeContent();
        result = result * 59 + ($disputeContent == null ? 43 : $disputeContent.hashCode());
        String $appeal = this.getAppeal();
        result = result * 59 + ($appeal == null ? 43 : $appeal.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $addressCode = this.getAddressCode();
        result = result * 59 + ($addressCode == null ? 43 : $addressCode.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $orgName = this.getOrgName();
        result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        Integer $downCount = this.getDownCount();
        result = result * 59 + ($downCount == null ? 43 : ((Object)$downCount).hashCode());
        String $lawCaseStatus = this.getLawCaseStatus();
        result = result * 59 + ($lawCaseStatus == null ? 43 : $lawCaseStatus.hashCode());
        Integer $approvalType = this.getApprovalType();
        result = result * 59 + ($approvalType == null ? 43 : ((Object)$approvalType).hashCode());
        String $caseUserType = this.getCaseUserType();
        result = result * 59 + ($caseUserType == null ? 43 : $caseUserType.hashCode());
        String $mediator = this.getMediator();
        result = result * 59 + ($mediator == null ? 43 : $mediator.hashCode());
        Long $mediatorId = this.getMediatorId();
        result = result * 59 + ($mediatorId == null ? 43 : ((Object)$mediatorId).hashCode());
        String $currentProgress = this.getCurrentProgress();
        result = result * 59 + ($currentProgress == null ? 43 : $currentProgress.hashCode());
        String $currentProgressCode = this.getCurrentProgressCode();
        result = result * 59 + ($currentProgressCode == null ? 43 : $currentProgressCode.hashCode());
        Integer $currentStep = this.getCurrentStep();
        result = result * 59 + ($currentStep == null ? 43 : ((Object)$currentStep).hashCode());
        List<ProgressDTO> $lawCaseProgress = this.getLawCaseProgress();
        result = result * 59 + ($lawCaseProgress == null ? 43 : ((Object)$lawCaseProgress).hashCode());
        String $currentProgressSuit = this.getCurrentProgressSuit();
        result = result * 59 + ($currentProgressSuit == null ? 43 : $currentProgressSuit.hashCode());
        String $currentProgressCodeSuit = this.getCurrentProgressCodeSuit();
        result = result * 59 + ($currentProgressCodeSuit == null ? 43 : $currentProgressCodeSuit.hashCode());
        Integer $currentStepSuit = this.getCurrentStepSuit();
        result = result * 59 + ($currentStepSuit == null ? 43 : ((Object)$currentStepSuit).hashCode());
        List<ProgressDTO> $lawCaseProgressSuit = this.getLawCaseProgressSuit();
        result = result * 59 + ($lawCaseProgressSuit == null ? 43 : ((Object)$lawCaseProgressSuit).hashCode());
        String $creatorType = this.getCreatorType();
        result = result * 59 + ($creatorType == null ? 43 : $creatorType.hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Boolean $caseRetract = this.getCaseRetract();
        result = result * 59 + ($caseRetract == null ? 43 : ((Object)$caseRetract).hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        Long $petitionAgentUserId = this.getPetitionAgentUserId();
        result = result * 59 + ($petitionAgentUserId == null ? 43 : ((Object)$petitionAgentUserId).hashCode());
        String $petitionAgentUserName = this.getPetitionAgentUserName();
        result = result * 59 + ($petitionAgentUserName == null ? 43 : $petitionAgentUserName.hashCode());
        Boolean $petitionAgentIsEvaluate = this.getPetitionAgentIsEvaluate();
        result = result * 59 + ($petitionAgentIsEvaluate == null ? 43 : ((Object)$petitionAgentIsEvaluate).hashCode());
        String $extendReason = this.getExtendReason();
        result = result * 59 + ($extendReason == null ? 43 : $extendReason.hashCode());
        Integer $extendDay = this.getExtendDay();
        result = result * 59 + ($extendDay == null ? 43 : ((Object)$extendDay).hashCode());
        Long $extendId = this.getExtendId();
        result = result * 59 + ($extendId == null ? 43 : ((Object)$extendId).hashCode());
        String $extendType = this.getExtendType();
        result = result * 59 + ($extendType == null ? 43 : $extendType.hashCode());
        String $extendTypeName = this.getExtendTypeName();
        result = result * 59 + ($extendTypeName == null ? 43 : $extendTypeName.hashCode());
        String $extendAction = this.getExtendAction();
        result = result * 59 + ($extendAction == null ? 43 : $extendAction.hashCode());
        String $extendActionName = this.getExtendActionName();
        result = result * 59 + ($extendActionName == null ? 43 : $extendActionName.hashCode());
        String $reasonType = this.getReasonType();
        result = result * 59 + ($reasonType == null ? 43 : $reasonType.hashCode());
        String $reasonTypeName = this.getReasonTypeName();
        result = result * 59 + ($reasonTypeName == null ? 43 : $reasonTypeName.hashCode());
        Boolean $isSuspend = this.getIsSuspend();
        result = result * 59 + ($isSuspend == null ? 43 : ((Object)$isSuspend).hashCode());
        Integer $suspendNum = this.getSuspendNum();
        result = result * 59 + ($suspendNum == null ? 43 : ((Object)$suspendNum).hashCode());
        Boolean $hadUnreadMsg = this.getHadUnreadMsg();
        result = result * 59 + ($hadUnreadMsg == null ? 43 : ((Object)$hadUnreadMsg).hashCode());
        Boolean $overTimeTips = this.getOverTimeTips();
        result = result * 59 + ($overTimeTips == null ? 43 : ((Object)$overTimeTips).hashCode());
        String $citeCaseType = this.getCiteCaseType();
        result = result * 59 + ($citeCaseType == null ? 43 : $citeCaseType.hashCode());
        String $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        String $caseType = this.getCaseType();
        result = result * 59 + ($caseType == null ? 43 : $caseType.hashCode());
        String $followPersonName = this.getFollowPersonName();
        result = result * 59 + ($followPersonName == null ? 43 : $followPersonName.hashCode());
        String $followPersonPhone = this.getFollowPersonPhone();
        result = result * 59 + ($followPersonPhone == null ? 43 : $followPersonPhone.hashCode());
        ArrayList<MediationCasePersonnelDTO> $mediationHelpDTOs = this.getMediationHelpDTOs();
        result = result * 59 + ($mediationHelpDTOs == null ? 43 : ((Object)$mediationHelpDTOs).hashCode());
        String $orgRoleType = this.getOrgRoleType();
        result = result * 59 + ($orgRoleType == null ? 43 : $orgRoleType.hashCode());
        Integer $simple = this.getSimple();
        result = result * 59 + ($simple == null ? 43 : ((Object)$simple).hashCode());
        String $disputeAmount = this.getDisputeAmount();
        result = result * 59 + ($disputeAmount == null ? 43 : $disputeAmount.hashCode());
        Boolean $allowExtend = this.getAllowExtend();
        result = result * 59 + ($allowExtend == null ? 43 : ((Object)$allowExtend).hashCode());
        Boolean $allowExtendConfirm = this.getAllowExtendConfirm();
        result = result * 59 + ($allowExtendConfirm == null ? 43 : ((Object)$allowExtendConfirm).hashCode());
        Boolean $orgConfirm = this.getOrgConfirm();
        result = result * 59 + ($orgConfirm == null ? 43 : ((Object)$orgConfirm).hashCode());
        Boolean $caseIsEvaluate = this.getCaseIsEvaluate();
        result = result * 59 + ($caseIsEvaluate == null ? 43 : ((Object)$caseIsEvaluate).hashCode());
        Boolean $isAllowWithdrawal = this.getIsAllowWithdrawal();
        result = result * 59 + ($isAllowWithdrawal == null ? 43 : ((Object)$isAllowWithdrawal).hashCode());
        Boolean $allowUp = this.getAllowUp();
        result = result * 59 + ($allowUp == null ? 43 : ((Object)$allowUp).hashCode());
        Boolean $allowDown = this.getAllowDown();
        result = result * 59 + ($allowDown == null ? 43 : ((Object)$allowDown).hashCode());
        Boolean $noEvidenceFlag = this.getNoEvidenceFlag();
        result = result * 59 + ($noEvidenceFlag == null ? 43 : ((Object)$noEvidenceFlag).hashCode());
        Boolean $noAllPhoneFlag = this.getNoAllPhoneFlag();
        result = result * 59 + ($noAllPhoneFlag == null ? 43 : ((Object)$noAllPhoneFlag).hashCode());
        Boolean $financialApprovalFlag = this.getFinancialApprovalFlag();
        result = result * 59 + ($financialApprovalFlag == null ? 43 : ((Object)$financialApprovalFlag).hashCode());
        Integer $showTransfer = this.getShowTransfer();
        result = result * 59 + ($showTransfer == null ? 43 : ((Object)$showTransfer).hashCode());
        Boolean $showTransferBtn = this.getShowTransferBtn();
        result = result * 59 + ($showTransferBtn == null ? 43 : ((Object)$showTransferBtn).hashCode());
        Boolean $showAcceptBtn = this.getShowAcceptBtn();
        result = result * 59 + ($showAcceptBtn == null ? 43 : ((Object)$showAcceptBtn).hashCode());
        Boolean $showNotAcceptBtn = this.getShowNotAcceptBtn();
        result = result * 59 + ($showNotAcceptBtn == null ? 43 : ((Object)$showNotAcceptBtn).hashCode());
        Boolean $showAllocationBtn = this.getShowAllocationBtn();
        result = result * 59 + ($showAllocationBtn == null ? 43 : ((Object)$showAllocationBtn).hashCode());
        Boolean $showReAllocationBtn = this.getShowReAllocationBtn();
        result = result * 59 + ($showReAllocationBtn == null ? 43 : ((Object)$showReAllocationBtn).hashCode());
        Boolean $showApplyExtensionBtn = this.getShowApplyExtensionBtn();
        result = result * 59 + ($showApplyExtensionBtn == null ? 43 : ((Object)$showApplyExtensionBtn).hashCode());
        Boolean $showRevokeApplyExtensionBtn = this.getShowRevokeApplyExtensionBtn();
        result = result * 59 + ($showRevokeApplyExtensionBtn == null ? 43 : ((Object)$showRevokeApplyExtensionBtn).hashCode());
        Boolean $showApplyReAllocationBtn = this.getShowApplyReAllocationBtn();
        result = result * 59 + ($showApplyReAllocationBtn == null ? 43 : ((Object)$showApplyReAllocationBtn).hashCode());
        Boolean $showVerifyExtensionBtn = this.getShowVerifyExtensionBtn();
        result = result * 59 + ($showVerifyExtensionBtn == null ? 43 : ((Object)$showVerifyExtensionBtn).hashCode());
        Boolean $showApplyCompleteBtn = this.getShowApplyCompleteBtn();
        result = result * 59 + ($showApplyCompleteBtn == null ? 43 : ((Object)$showApplyCompleteBtn).hashCode());
        Boolean $showVerifyCompleteBtn = this.getShowVerifyCompleteBtn();
        result = result * 59 + ($showVerifyCompleteBtn == null ? 43 : ((Object)$showVerifyCompleteBtn).hashCode());
        Boolean $showVerifyReAllocationBtn = this.getShowVerifyReAllocationBtn();
        result = result * 59 + ($showVerifyReAllocationBtn == null ? 43 : ((Object)$showVerifyReAllocationBtn).hashCode());
        Boolean $showDelayCancelBtn = this.getShowDelayCancelBtn();
        result = result * 59 + ($showDelayCancelBtn == null ? 43 : ((Object)$showDelayCancelBtn).hashCode());
        Integer $isTurnToSw = this.getIsTurnToSw();
        result = result * 59 + ($isTurnToSw == null ? 43 : ((Object)$isTurnToSw).hashCode());
        Long $swCaseId = this.getSwCaseId();
        result = result * 59 + ($swCaseId == null ? 43 : ((Object)$swCaseId).hashCode());
        String $swCaseNo = this.getSwCaseNo();
        result = result * 59 + ($swCaseNo == null ? 43 : $swCaseNo.hashCode());
        Date $turnTime = this.getTurnTime();
        result = result * 59 + ($turnTime == null ? 43 : ((Object)$turnTime).hashCode());
        Integer $matchesResult = this.getMatchesResult();
        result = result * 59 + ($matchesResult == null ? 43 : ((Object)$matchesResult).hashCode());
        Integer $intelligentReviewResult = this.getIntelligentReviewResult();
        result = result * 59 + ($intelligentReviewResult == null ? 43 : ((Object)$intelligentReviewResult).hashCode());
        List<DossAttachmentResDTO> $documents = this.getDocuments();
        result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
        String $resolutionType = this.getResolutionType();
        result = result * 59 + ($resolutionType == null ? 43 : $resolutionType.hashCode());
        return result;
    }

    public String toString() {
        return "MediationResponseDTO(signStatus=" + this.getSignStatus() + ", callbackType=" + this.getCallbackType() + ", callbackSeq=" + this.getCallbackSeq() + ", caseId=" + this.getCaseId() + ", disputeType=" + this.getDisputeType() + ", disputeTypeCode=" + this.getDisputeTypeCode() + ", caseNo=" + this.getCaseNo() + ", mediationType=" + this.getMediationType() + ", mediationTypeCode=" + this.getMediationTypeCode() + ", applicantName=" + this.getApplicantName() + ", applicantIds=" + this.getApplicantIds() + ", applicantAgentName=" + this.getApplicantAgentName() + ", applicantAgentIds=" + this.getApplicantAgentIds() + ", respondentName=" + this.getRespondentName() + ", respondentIds=" + this.getRespondentIds() + ", respondentAgentName=" + this.getRespondentAgentName() + ", respondentAgentIds=" + this.getRespondentAgentIds() + ", disputeContent=" + this.getDisputeContent() + ", appeal=" + this.getAppeal() + ", address=" + this.getAddress() + ", addressCode=" + this.getAddressCode() + ", createTime=" + this.getCreateTime() + ", orgName=" + this.getOrgName() + ", orgId=" + this.getOrgId() + ", downCount=" + this.getDownCount() + ", lawCaseStatus=" + this.getLawCaseStatus() + ", approvalType=" + this.getApprovalType() + ", caseUserType=" + this.getCaseUserType() + ", mediator=" + this.getMediator() + ", mediatorId=" + this.getMediatorId() + ", currentProgress=" + this.getCurrentProgress() + ", currentProgressCode=" + this.getCurrentProgressCode() + ", currentStep=" + this.getCurrentStep() + ", lawCaseProgress=" + this.getLawCaseProgress() + ", currentProgressSuit=" + this.getCurrentProgressSuit() + ", currentProgressCodeSuit=" + this.getCurrentProgressCodeSuit() + ", currentStepSuit=" + this.getCurrentStepSuit() + ", lawCaseProgressSuit=" + this.getLawCaseProgressSuit() + ", creatorType=" + this.getCreatorType() + ", startTime=" + this.getStartTime() + ", caseRetract=" + this.getCaseRetract() + ", creatorId=" + this.getCreatorId() + ", petitionAgentUserId=" + this.getPetitionAgentUserId() + ", petitionAgentUserName=" + this.getPetitionAgentUserName() + ", petitionAgentIsEvaluate=" + this.getPetitionAgentIsEvaluate() + ", extendReason=" + this.getExtendReason() + ", extendDay=" + this.getExtendDay() + ", extendId=" + this.getExtendId() + ", extendType=" + this.getExtendType() + ", extendTypeName=" + this.getExtendTypeName() + ", extendAction=" + this.getExtendAction() + ", extendActionName=" + this.getExtendActionName() + ", reasonType=" + this.getReasonType() + ", reasonTypeName=" + this.getReasonTypeName() + ", isSuspend=" + this.getIsSuspend() + ", suspendNum=" + this.getSuspendNum() + ", hadUnreadMsg=" + this.getHadUnreadMsg() + ", overTimeTips=" + this.getOverTimeTips() + ", citeCaseType=" + this.getCiteCaseType() + ", origin=" + this.getOrigin() + ", caseType=" + this.getCaseType() + ", followPersonName=" + this.getFollowPersonName() + ", followPersonPhone=" + this.getFollowPersonPhone() + ", mediationHelpDTOs=" + this.getMediationHelpDTOs() + ", orgRoleType=" + this.getOrgRoleType() + ", simple=" + this.getSimple() + ", disputeAmount=" + this.getDisputeAmount() + ", allowExtend=" + this.getAllowExtend() + ", allowExtendConfirm=" + this.getAllowExtendConfirm() + ", orgConfirm=" + this.getOrgConfirm() + ", caseIsEvaluate=" + this.getCaseIsEvaluate() + ", isAllowWithdrawal=" + this.getIsAllowWithdrawal() + ", allowUp=" + this.getAllowUp() + ", allowDown=" + this.getAllowDown() + ", noEvidenceFlag=" + this.getNoEvidenceFlag() + ", noAllPhoneFlag=" + this.getNoAllPhoneFlag() + ", financialApprovalFlag=" + this.getFinancialApprovalFlag() + ", showTransfer=" + this.getShowTransfer() + ", showTransferBtn=" + this.getShowTransferBtn() + ", showAcceptBtn=" + this.getShowAcceptBtn() + ", showNotAcceptBtn=" + this.getShowNotAcceptBtn() + ", showAllocationBtn=" + this.getShowAllocationBtn() + ", showReAllocationBtn=" + this.getShowReAllocationBtn() + ", showApplyExtensionBtn=" + this.getShowApplyExtensionBtn() + ", showRevokeApplyExtensionBtn=" + this.getShowRevokeApplyExtensionBtn() + ", showApplyReAllocationBtn=" + this.getShowApplyReAllocationBtn() + ", showVerifyExtensionBtn=" + this.getShowVerifyExtensionBtn() + ", showApplyCompleteBtn=" + this.getShowApplyCompleteBtn() + ", showVerifyCompleteBtn=" + this.getShowVerifyCompleteBtn() + ", showVerifyReAllocationBtn=" + this.getShowVerifyReAllocationBtn() + ", showDelayCancelBtn=" + this.getShowDelayCancelBtn() + ", isTurnToSw=" + this.getIsTurnToSw() + ", swCaseId=" + this.getSwCaseId() + ", swCaseNo=" + this.getSwCaseNo() + ", turnTime=" + this.getTurnTime() + ", matchesResult=" + this.getMatchesResult() + ", intelligentReviewResult=" + this.getIntelligentReviewResult() + ", documents=" + this.getDocuments() + ", resolutionType=" + this.getResolutionType() + ")";
    }
}

