/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.usergateway.domain.dto.responsedto;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.arbitration.dto.responsedto.SuitListResDTO;
import com.beiming.odr.arbitration.enums.SuitStatusEnum;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import com.beiming.odr.usergateway.domain.dto.ProgressDTO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ApiModel(value="\u8bc9\u8bbc\u5217\u8868\u8fd4\u56de\u53c2\u6570")
public class SuitInfoResponseDTO
implements Serializable {
    @ApiModelProperty(value="\u4e3b\u952e")
    private Long id;
    @ApiModelProperty(value="\u6848\u4ef6\u7f16\u53f7")
    private String caseNo;
    @ApiModelProperty(value="\u7ea0\u7eb7\u7c7b\u578b")
    private String disputeType;
    @ApiModelProperty(value="\u6848\u7531")
    private String causeName;
    @ApiModelProperty(value="\u8bc9\u6c42\u4fe1\u606f")
    private String appeal;
    @ApiModelProperty(value="\u521b\u5efa\u65f6\u95f4")
    private String createTime;
    @ApiModelProperty(value="\u6cd5\u9662\u540d\u79f0")
    private String courtName;
    @ApiModelProperty(value="\u7533\u8bf7\u4eba")
    private String applicantName;
    @ApiModelProperty(value="\u88ab\u7533\u8bf7\u4eba")
    private String respondentName;
    @ApiModelProperty(value="\u8fdb\u5ea6")
    private List<ProgressDTO> suitProgress;
    @ApiModelProperty(value="\u5f53\u524d\u8fdb\u5ea6")
    private String currentProgress;
    @ApiModelProperty(value="\u8bc9\u8bbc\u72b6\u6001")
    private String suitStatus;
    @ApiModelProperty(value="\u5f53\u524d\u6b65\u9aa4")
    private Integer currentStep;
    @ApiModelProperty(value="\u6848\u4ef6id")
    private Long lawCaseId;
    private String suitNo;

    public SuitInfoResponseDTO(SuitListResDTO suitListResDTO) {
        this.id = suitListResDTO.getId();
        this.caseNo = suitListResDTO.getThirdSuitId();
        this.disputeType = suitListResDTO.getDisputeType();
        this.causeName = suitListResDTO.getCauseName();
        this.appeal = suitListResDTO.getAppeal();
        this.createTime = Java8DateUtil.formatter((Date)suitListResDTO.getCreateTime(), (String)"yyyy-MM-dd");
        this.courtName = suitListResDTO.getCourtName();
        this.lawCaseId = suitListResDTO.getLawCaseId();
        this.suitNo = suitListResDTO.getSuitNo();
        String applicantName = "";
        for (Object applicant : suitListResDTO.getApplicants()) {
            if (StringUtils.isNotEmpty((CharSequence)applicantName)) {
                applicantName = applicantName + "," + (String)applicant;
                continue;
            }
            applicantName = applicantName + (String)applicant;
        }
        this.applicantName = applicantName;
        String respondentName = "";
        for (String respondent : suitListResDTO.getRespondents()) {
            if (StringUtils.isNotEmpty((CharSequence)respondentName)) {
                respondentName = respondentName + "," + respondent;
                continue;
            }
            respondentName = respondentName + respondent;
        }
        this.respondentName = respondentName;
        ArrayList<ProgressDTO> progresses = new ArrayList<ProgressDTO>();
        List progressDTOs = suitListResDTO.getProgressList();
        int i = 1;
        for (com.beiming.odr.arbitration.dto.ProgressDTO progressDTO : progressDTOs) {
            if (progressDTO.getIsActive().booleanValue()) {
                this.currentProgress = progressDTO.getProgressName();
                this.currentStep = i;
            }
            ProgressDTO progress = new ProgressDTO(progressDTO.getProgressName(), progressDTO.getIsActive(), i);
            progresses.add(progress);
            ++i;
        }
        this.suitProgress = progresses;
        if (suitListResDTO.getSuitStatus() != null) {
            this.suitStatus = SuitStatusEnum.ENTERING_SUCCESS.name().equals(suitListResDTO.getSuitStatus().name()) ? "\u5165\u5e93\u6210\u529f" : (SuitStatusEnum.ENTERING_FAILED.name().equals(suitListResDTO.getSuitStatus().name()) ? "\u5165\u5e93\u5931\u8d25" : (SuitStatusEnum.CHECK_SUCCESS.name().equals(suitListResDTO.getSuitStatus().name()) ? "\u5ba1\u6838\u6210\u529f" : (SuitStatusEnum.CHECK_FAILED.name().equals(suitListResDTO.getSuitStatus().name()) ? "\u5ba1\u6838\u5931\u8d25" : "\u5f85\u5165\u5e93")));
        }
    }

    public SuitInfoResponseDTO() {
    }

    public Long getId() {
        return this.id;
    }

    public String getCaseNo() {
        return this.caseNo;
    }

    public String getDisputeType() {
        return this.disputeType;
    }

    public String getCauseName() {
        return this.causeName;
    }

    public String getAppeal() {
        return this.appeal;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getCourtName() {
        return this.courtName;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public String getRespondentName() {
        return this.respondentName;
    }

    public List<ProgressDTO> getSuitProgress() {
        return this.suitProgress;
    }

    public String getCurrentProgress() {
        return this.currentProgress;
    }

    public String getSuitStatus() {
        return this.suitStatus;
    }

    public Integer getCurrentStep() {
        return this.currentStep;
    }

    public Long getLawCaseId() {
        return this.lawCaseId;
    }

    public String getSuitNo() {
        return this.suitNo;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCaseNo(String caseNo) {
        this.caseNo = caseNo;
    }

    public void setDisputeType(String disputeType) {
        this.disputeType = disputeType;
    }

    public void setCauseName(String causeName) {
        this.causeName = causeName;
    }

    public void setAppeal(String appeal) {
        this.appeal = appeal;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public void setCourtName(String courtName) {
        this.courtName = courtName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public void setRespondentName(String respondentName) {
        this.respondentName = respondentName;
    }

    public void setSuitProgress(List<ProgressDTO> suitProgress) {
        this.suitProgress = suitProgress;
    }

    public void setCurrentProgress(String currentProgress) {
        this.currentProgress = currentProgress;
    }

    public void setSuitStatus(String suitStatus) {
        this.suitStatus = suitStatus;
    }

    public void setCurrentStep(Integer currentStep) {
        this.currentStep = currentStep;
    }

    public void setLawCaseId(Long lawCaseId) {
        this.lawCaseId = lawCaseId;
    }

    public void setSuitNo(String suitNo) {
        this.suitNo = suitNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SuitInfoResponseDTO)) {
            return false;
        }
        SuitInfoResponseDTO other = (SuitInfoResponseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$caseNo = this.getCaseNo();
        String other$caseNo = other.getCaseNo();
        if (this$caseNo == null ? other$caseNo != null : !this$caseNo.equals(other$caseNo)) {
            return false;
        }
        String this$disputeType = this.getDisputeType();
        String other$disputeType = other.getDisputeType();
        if (this$disputeType == null ? other$disputeType != null : !this$disputeType.equals(other$disputeType)) {
            return false;
        }
        String this$causeName = this.getCauseName();
        String other$causeName = other.getCauseName();
        if (this$causeName == null ? other$causeName != null : !this$causeName.equals(other$causeName)) {
            return false;
        }
        String this$appeal = this.getAppeal();
        String other$appeal = other.getAppeal();
        if (this$appeal == null ? other$appeal != null : !this$appeal.equals(other$appeal)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$courtName = this.getCourtName();
        String other$courtName = other.getCourtName();
        if (this$courtName == null ? other$courtName != null : !this$courtName.equals(other$courtName)) {
            return false;
        }
        String this$applicantName = this.getApplicantName();
        String other$applicantName = other.getApplicantName();
        if (this$applicantName == null ? other$applicantName != null : !this$applicantName.equals(other$applicantName)) {
            return false;
        }
        String this$respondentName = this.getRespondentName();
        String other$respondentName = other.getRespondentName();
        if (this$respondentName == null ? other$respondentName != null : !this$respondentName.equals(other$respondentName)) {
            return false;
        }
        List<ProgressDTO> this$suitProgress = this.getSuitProgress();
        List<ProgressDTO> other$suitProgress = other.getSuitProgress();
        if (this$suitProgress == null ? other$suitProgress != null : !((Object)this$suitProgress).equals(other$suitProgress)) {
            return false;
        }
        String this$currentProgress = this.getCurrentProgress();
        String other$currentProgress = other.getCurrentProgress();
        if (this$currentProgress == null ? other$currentProgress != null : !this$currentProgress.equals(other$currentProgress)) {
            return false;
        }
        String this$suitStatus = this.getSuitStatus();
        String other$suitStatus = other.getSuitStatus();
        if (this$suitStatus == null ? other$suitStatus != null : !this$suitStatus.equals(other$suitStatus)) {
            return false;
        }
        Integer this$currentStep = this.getCurrentStep();
        Integer other$currentStep = other.getCurrentStep();
        if (this$currentStep == null ? other$currentStep != null : !((Object)this$currentStep).equals(other$currentStep)) {
            return false;
        }
        Long this$lawCaseId = this.getLawCaseId();
        Long other$lawCaseId = other.getLawCaseId();
        if (this$lawCaseId == null ? other$lawCaseId != null : !((Object)this$lawCaseId).equals(other$lawCaseId)) {
            return false;
        }
        String this$suitNo = this.getSuitNo();
        String other$suitNo = other.getSuitNo();
        return !(this$suitNo == null ? other$suitNo != null : !this$suitNo.equals(other$suitNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SuitInfoResponseDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $caseNo = this.getCaseNo();
        result = result * 59 + ($caseNo == null ? 43 : $caseNo.hashCode());
        String $disputeType = this.getDisputeType();
        result = result * 59 + ($disputeType == null ? 43 : $disputeType.hashCode());
        String $causeName = this.getCauseName();
        result = result * 59 + ($causeName == null ? 43 : $causeName.hashCode());
        String $appeal = this.getAppeal();
        result = result * 59 + ($appeal == null ? 43 : $appeal.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $courtName = this.getCourtName();
        result = result * 59 + ($courtName == null ? 43 : $courtName.hashCode());
        String $applicantName = this.getApplicantName();
        result = result * 59 + ($applicantName == null ? 43 : $applicantName.hashCode());
        String $respondentName = this.getRespondentName();
        result = result * 59 + ($respondentName == null ? 43 : $respondentName.hashCode());
        List<ProgressDTO> $suitProgress = this.getSuitProgress();
        result = result * 59 + ($suitProgress == null ? 43 : ((Object)$suitProgress).hashCode());
        String $currentProgress = this.getCurrentProgress();
        result = result * 59 + ($currentProgress == null ? 43 : $currentProgress.hashCode());
        String $suitStatus = this.getSuitStatus();
        result = result * 59 + ($suitStatus == null ? 43 : $suitStatus.hashCode());
        Integer $currentStep = this.getCurrentStep();
        result = result * 59 + ($currentStep == null ? 43 : ((Object)$currentStep).hashCode());
        Long $lawCaseId = this.getLawCaseId();
        result = result * 59 + ($lawCaseId == null ? 43 : ((Object)$lawCaseId).hashCode());
        String $suitNo = this.getSuitNo();
        result = result * 59 + ($suitNo == null ? 43 : $suitNo.hashCode());
        return result;
    }

    public String toString() {
        return "SuitInfoResponseDTO(id=" + this.getId() + ", caseNo=" + this.getCaseNo() + ", disputeType=" + this.getDisputeType() + ", causeName=" + this.getCauseName() + ", appeal=" + this.getAppeal() + ", createTime=" + this.getCreateTime() + ", courtName=" + this.getCourtName() + ", applicantName=" + this.getApplicantName() + ", respondentName=" + this.getRespondentName() + ", suitProgress=" + this.getSuitProgress() + ", currentProgress=" + this.getCurrentProgress() + ", suitStatus=" + this.getSuitStatus() + ", currentStep=" + this.getCurrentStep() + ", lawCaseId=" + this.getLawCaseId() + ", suitNo=" + this.getSuitNo() + ")";
    }
}

