package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.CourtLongCountResDTO;

import java.util.ArrayList;

/**
 * 机构相关接口
 *
 * @author fanheshui
 */
public interface BackstageOrganizationServiceApi {
  /**
   * 新增机构信息
   *
   * @param
   */
  public DubboResult<Long> addBackstageOrganization(BackstageOrganizationAddReqDTO req);

  /**
   * 编辑机构信息
   *
   * @param
   */
  public DubboResult<Long> updateBackstageOrganization(BackstageOrganizationUpdateReqDTO req);


  /**
   * 查询机构信息
   *
   * @param
   */
  public DubboResult<BackstageOrganizationResDTO> searchBackstageOrganization(
      BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息
   *
   * @param
   */
   DubboResult<BackstageOrganizationResDTO> searchNearestOrganization(
      BackstageOrganizationSearchReqDTO req);

  DubboResult<BackstageOrganizationResDTO> searchNearestCourt(
      BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息 列表
   *
   * @param
   */
  public DubboResult<PageInfo<BackstageOrganizationResDTO>> listBackstageOrganization(
      BackstageOrganizationListReqDTO req);

  DubboResult<BackstageOrganizationResDTO> getOrganizationByName(BackstageOrganizationListReqDTO req);

  DubboResult<BackstageOrganizationResDTO> getOrganizationForConference(String currentUserId);


  /**
   * 批量同步数据到通达海中
   */
  DubboResult sysncTdhOrgList(Long orgId, String courtCode);

  DubboResult sysncTdhOrgList();


  /**
   * 根据父ID查询所有子机构
   *
   * @param id
   * @return
   */
  DubboResult<ArrayList<BackstageOrganizationResDTO>> getSubOrganizationByParentId(Long id);


  /**
   * 根据父ID查询子机构,含父机构
   *
   * @param id
   * @return
   */
  DubboResult<BackstageOrganizationResDTO> getSubOrganizationTreeByParentId(Long id);

  /**
   * 查询法院工作人员某天的登录次数
   *
   * @param date
   * @return
   */
  DubboResult<ArrayList<CourtLongCountResDTO>> getCourtUserLoginCount(String date);


}
