package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;

/**
 * 工作人员相关接口
 * 
 * @author fanheshui
 */
public interface BackstageUserServiceApi {
  /**
   * 添加工作人员
   */

  DubboResult<Long> insertBackstageUser(BackstageUserAddReqDTO backstageUserAddReqDTO);

  /**
   * 修改工作人员
   */
  DubboResult<Long> updateBackstageUser(BackstageUserAddReqDTO backstageuserAddReqDTO);

  /**
   * 查询工作人员
   */
  DubboResult<BackstageUserInfoResDTO> searchBackstageUser(
      BackstageUserSearchReqDTO backstageUserSearchReqDTO);

  DubboResult<BackstageUserInfoResDTO> searchUserByPhone(String mobilePhone);
  /**
   * 更新工作人员状态-禁用或启用
   */
  DubboResult updateBackstageUserStatus(BackstageUserUpdateStatusReqDTO req);

  /**
   * 工作人员列表
   */
  DubboResult<PageInfo<BackstageUserInfoResDTO>> listBackstageUser(
      BackstageUserListReqDTO backstageUserListReqDTO);
}
