package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.OpenApiCauseTree;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DisputeSearchReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DisputeTypeTreeResDTO;
import com.beiming.odr.user.api.enums.DisputeTypeCaseTypeEnum;
import java.util.ArrayList;
import java.util.List;

public interface DisputeTypeApi {

  /**
   * 查询纠纷类型树结构
   *
   * @return
   * @param build
   */
  DubboResult<DisputeTypeTreeResDTO> getDisputeTypeTree(
      DisputeSearchReqDTO build);

  /**
   * 根据父code查询子纠纷类型
   *
   * @param req
   * @return
   */
  DubboResult<ArrayList<DisputeTypeTreeResDTO>> getChildren(CommonIdReqDTO req);


  /**
   * 查询纠纷类型详细信息
   *
   * @param
   * @return
   */
  DubboResult<DisputeTypeTreeResDTO> getByCode(CommonIdReqDTO req);


  /**
   * 查询纠纷类型对应的案件类型
   *
   * @param
   * @return
   */
  DubboResult<DisputeTypeCaseTypeEnum> getCaseTypeByCode(CommonIdReqDTO req);

  DubboResult<ArrayList<OpenApiCauseTree>> causeTree(String causeName);


}
