package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DisputeTypeEarlyWarningMonitorSearchReqDTO;
import com.beiming.odr.user.api.dto.responsedto.DisputeTypeEarlyWarningMonitorInfoResDTO;
import javax.validation.Valid;

/**
 * 纠纷类型预警监控相关接口
 *
 * @author fanheshui
 */
@Valid
public interface DisputeTypeEarlyWarningMonitorServiceApi {
  /**
   * 添加纠纷类型预警监控
   */

  DubboResult insertData(@Valid DisputeTypeEarlyWarningMonitorAddReqDTO request);

  /**
   * 修改纠纷类型预警监控
   */
  DubboResult updateData(@Valid DisputeTypeEarlyWarningMonitorAddReqDTO request);

  /**
   * 查询纠纷类型预警监控
   */
  DubboResult<DisputeTypeEarlyWarningMonitorInfoResDTO> searchData(
      @Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 删除数据
   */
  DubboResult deleteData(@Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 暂停或者启用-状态相互切换
   */
  DubboResult updateSuspendFlagData(@Valid DisputeTypeEarlyWarningMonitorSearchReqDTO request);

  /**
   * 纠纷类型预警监控列表
   */
  DubboResult<PageInfo<DisputeTypeEarlyWarningMonitorInfoResDTO>> listData(
      @Valid DisputeTypeEarlyWarningMonitorListReqDTO request);
}
