package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.FunctionUsageStatisticsAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.FunctionUsageStatisticsExportReqDTO;
import com.beiming.odr.user.api.dto.requestdto.FunctionUsageStatisticsListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.FunctionUsageStatisticsListExportResDTO;
import com.beiming.odr.user.api.dto.responsedto.FunctionUsageStatisticsListResDTO;
import com.beiming.odr.user.api.dto.responsedto.FunctionUsageStatisticsResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能使用统计信息
 */
public interface FunctionUsageStatisticsServiceApi {

  /**
   * 新增
   */
  DubboResult<Boolean> add(FunctionUsageStatisticsAddReqDTO addReqDTO);

  /**
   * 汇总信息查询
   */
  DubboResult<FunctionUsageStatisticsResDTO> useSummary();

  /**
   * 分页查询
   */
  DubboResult<PageInfo<FunctionUsageStatisticsListResDTO>> queryPageList(
      FunctionUsageStatisticsListReqDTO listReqDTO);

  /***
   * 调用小程序获取访问数据并存储
   * @return
   */
  DubboResult invokeOpenApiWechatVisitData();

  /***
   * 获取小程序获取访问总次数
   * @return
   */
  DubboResult<Integer> getVisitPv();

  DubboResult<ArrayList<FunctionUsageStatisticsListExportResDTO>>
  selectExportData(FunctionUsageStatisticsExportReqDTO exportReqDTO);

}