package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OrdinaryUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrdinaryUserInfoResDTO;
import javax.validation.Valid;

/**
 * 普通用户相关接口
 *
 * @author fanheshui
 */
@Valid
public interface OrdinaryUserServiceApi {
  /**
   * 添加普通用户
   */

  DubboResult insertOrdinaryUser(@Valid OrdinaryUserAddReqDTO ordinaryUserAddReqDTO);

  /**
   * 查询普通用户
   */
  DubboResult<OrdinaryUserInfoResDTO> searchOrdinaryUser(
      @Valid OrdinaryUserSearchReqDTO ordinaryUserSearchReqDTO);


  /**
   * 修改普通用户
   */
  DubboResult updateOrdinaryUser(@Valid OrdinaryUserUpdateReqDTO ordinaryUserUpdateReqDTO);


  /**
   * 普通用户列表
   */
  DubboResult<PageInfo<OrdinaryUserInfoResDTO>> listOrdinaryUser(
      @Valid  OrdinaryUserListReqDTO ordinaryUserListReqDTO);

  /**
   * 查询普通用户-新版
   */
  DubboResult<OrdinaryUserInfoResDTO> searchOrdinaryUserNew(
      @Valid OrdinaryUserSearchReqDTO ordinaryUserSearchReqDTO);

  /**
   * 普通用户列表-新版
   */
  DubboResult<PageInfo<OrdinaryUserInfoResDTO>> listOrdinaryUserNew(
      @Valid  OrdinaryUserListReqDTO ordinaryUserListReqDTO);
}
