package com.beiming.odr.user.api;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.OpenApiReq;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RecommendOrganizationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelOrgInfoSingleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.HomeDataCountResDTO;
import com.beiming.odr.user.api.dto.responsedto.OpenApiDataResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgInfoSingleResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgListOrderByMediatorNumberResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgaizationCourtDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationCityCodeResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationTree;
import com.beiming.odr.user.api.dto.responsedto.SZOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonNumberResDTO;
import com.beiming.odr.user.api.dto.responsedto.ZdzOrgNumDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;


public interface OrganizationServiceApi {

  /**
   * 智能推荐调解机构
   *
   * @param recommendOrganizationReqDTO
   * @return
   */
  DubboResult<OrganizationResDTO> getRecommendOrganization(
      RecommendOrganizationReqDTO recommendOrganizationReqDTO);

  /**
   * 选择调解机构列表分页
   *
   * @param organizationListReqDTO
   * @return
   */
  DubboResult<PageInfo<OrganizationResDTO>> getMediateOrganizationListPage(
      OrganizationListReqDTO organizationListReqDTO);

  /**
   * 获取机构列表分页
   *
   * @param getOrganizationPageRequestDTO
   * @return
   */
  DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPage(
      OrganizationListReqDTO organizationListReqDTO);

  /**
   * 推荐机构列表根据调解员数量倒序 limit 5
   *
   * @param currentUserId
   * @return
   */
  DubboResult<ArrayList<OrgListOrderByMediatorNumberResDTO>> getOrgListOrderByMediatorNumber(
      String disputeTypeCode, String currentUserId);

  /**
   * 获取机构详情
   *
   * @param orgId
   * @return
   */
  DubboResult<OrganizationResDTO> getOrganizationDetail(Long orgId);

  /**
   * 查询机构下服务人员的数量
   *
   * @param orgId
   * @return
   */
  DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(List<Long> orgIds);

  /**
   * 查询机构下服务人员的数量
   *
   * @param orgId
   * @return
   */
  DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(List<Long> orgIds,
      String currentUserId);

  /**
   * 查询首页统计数据
   *
   * @return
   */
  DubboResult<HomeDataCountResDTO> getHomeDataCount();

  /**
   * 查询机构总数量
   *
   * @return
   */
  DubboResult<Integer> getAllOrganizationCount();

  /**
   * 得到机构管理员所在的机构id
   */
  DubboResult<Long> getOrgIdByOrgManageUser(Long userId);

  /**
   * 通过机构管理员或区域管理员id获取所在区域
   *
   * @param userId
   * @return
   */
  DubboResult<String> getAreaCodeByManageUserId(Long userId);

  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   *
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoList(
      @Valid SelOrgInfoSingleReqDTO arg0);

  DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfo(
      @Valid SelOrgInfoSingleReqDTO arg0);

  /**
   * <pre>
   * 传入调解员或机构管理员的userId查询其绑定的所以机构的简易信息
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoByUserId(String userId);

  /**
   * 根据机构id和要查询的角色类型，返回对应的角色类型的用户详情
   *
   * @param orgId 机构id
   * @param roleTypeEnumList 角色类型列表
   */
  DubboResult<ArrayList<UserInfoDTO>> getUserInfoByOrgIdAndRoleType(Long orgId,
      List<RoleTypeEnum> roleTypeEnumList);

  /**
   * 非诉根据转办odrAreaCode获取机构信息
   *
   * @param orgAreaCode
   * @param level       3为市级
   * @return
   */
  DubboResult<OrganizationResDTO> getOrgInfoByFeiSuAreaCode(String orgAreaCode, String level);

  /**
   * 法院CODE来查询机构
   *
   * @param code
   * @return
   */
  DubboResult<OrganizationResDTO> getOrganizationDetailByCode(String code);

  /**
   * 获取可用机构名字不包含测试机构
   *
   * @return
   */
  DubboResult<String[]> getAllOrganizationName();

  /**
   * 获取创建时间<=time的所有机构数据不包含测试机构
   *
   * @return
   */
  DubboResult<ArrayList<OrganizationResDTO>> selectOrgAllNotIncludeTest(String time);

  /**
   * 获取机构城市代码
   */
  DubboResult<ArrayList<OrganizationCityCodeResDTO>> getOrgCityCode(List<Long> orgIds);

  /**
   * 获取机构对应特邀调解结构
   *
   * @param time
   * @return
   */
  DubboResult<JSONObject> getOrgTeyaoFuture(String time, Long orgId);

  /**
   * 查询机构总数量
   *
   * @return
   */
  DubboResult<Integer> getAllOrganizationCount(Long level, String areaCode);

  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   *
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<ZdzOrgNumDTO>> getZdzOrgNum(String orgName, String areaCode);

  /**
   * 获取所有总对总机构id
   *
   * @return
   */
  DubboResult<ArrayList<Long>> getZdzOrgIds();

  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   *
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<ZdzOrgNumDTO>> getSYZLOrgNum(String orgName, String areaCode);

  /**
   * 获取所有诉源治理机构id
   *
   * @return
   */
  DubboResult<ArrayList<Long>> getSyzlOrgIds();

  /**
   * 获取上级法院code
   *
   * @return
   */
  DubboResult<String> getParentCourtCode(Long parentId);

  /**
   * 获取上级法院
   * @return
   */
  DubboResult<OrganizationResDTO> getParentCourtCodeInfo(Long parentId);
  /***
   * 获取指定地市和纠纷类型下的机构
   * @param cityCode
   * @param disputeTypeCode
   * @return
   */
  DubboResult<ArrayList<OrganizationResDTO>> getOrgInfoByCityCodeAndDisputeTypeCode(String cityCode,
      String disputeTypeCode);

  DubboResult<ArrayList<OrgaizationCourtDTO>> courtList(List<String> fyIds);

  DubboResult<ArrayList<OrganizationTree>> orgTree(String orgName, String serviceAreaCode, String mediateCode, String typeCode, List<String> fyIds);
  DubboResult<ArrayList<String>> getChildIds(List<String> ids);

  List<OrganizationResDTO> checkUserCasePermission(Long userId);

  DubboResult<ArrayList<OpenApiDataResDTO>> getCaseOrgList(List<String> orgIdList);

  DubboResult<ArrayList<OrganizationTree>> getOrgList(OpenApiReq req);

  DubboResult<SZOrganizationResDTO> getOrgDetail(OpenApiReq req);

  /**
   * 三进案件提级时根据村级单位Id获取镇级单位
   * @param orgId
   * @return
   */
  DubboResult getParentCode(String orgId);
}
