package com.beiming.odr.user.api;

import com.alibaba.fastjson.JSONArray;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.PopupInfoDTO;
import java.util.List;

public interface PopupServiceApi {

  /**
   * 获取弹窗列表
   * @return
   */
  DubboResult<PageInfo<PopupInfoDTO>> getList();

  /**
   * 批量编辑弹窗信息
   * @param jsonArray
   */
  void editPopupInfo(JSONArray jsonArray);

  /**
   * 用户获取弹窗信息
   * @return
   */
  DubboResult<PageInfo<PopupInfoDTO>> getPopupInfo(Long userId, List<String> roles);

  void closingPrompt(Long id, Long userId);

  /**
   * 游客获取弹窗信息
   * @return
   */
  DubboResult<PageInfo<PopupInfoDTO>> getPopupInfoTourist();

}
