package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.MenuInterfaceDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleDeleteReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResListDTO;

import java.util.ArrayList;
import java.util.List;

public interface RoleServiceApi {
  /**
   * 角色的新增
   */

  DubboResult insertRole(RoleAddReqDTO roleAddReqDTO);

  /**
   * 角色的修改
   */
  DubboResult updateRole(RoleUpdateReqDTO roleUpdateReqDTO);

  /**
   * 角色列表
   */
  DubboResult<PageInfo<RoleInfoResDTO>> listRole(RoleListReqDTO roleListReqDTO);

  /**
   * 获取角色信息
   */
  DubboResult<RoleInfoResDTO> getRoleCode(RoleSearchReqDTO roleSearchReqDTO);

  /**
   * 角色删除
   */
  DubboResult deleteRole(RoleDeleteReqDTO roleDeleteReqDTO);

  /**
   * 查询工作人员角色
   */
  DubboResult<RoleInfoResListDTO> searchWorkUserRole(RoleSearchReqDTO roleSearchReqDTO);

  /**
   * 获取可用的角色名
   *
   * @return
   */
  DubboResult<String[]> getAllRoleName();

  DubboResult<ArrayList<MenuInterfaceDTO>> getMenuInterfaces(List<String> roles);

  DubboResult<ArrayList<MenuInterfaceDTO>> getMenuInterfacesCommon();

  DubboResult<ArrayList<MenuInterfaceDTO>> getMenuInterfacesForRole(String role);

  DubboResult<ArrayList<MenuInterfaceDTO>> getMenuInterfacesForAll();

}
