package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateCommendReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOrganizationAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOrganizationAuthReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOrganizationDetailResDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOrganizationPageListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOrganizationUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOutStoreReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateStudyReqDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateOrgCertResDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateOrganizationAddResDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateOrganizationListResDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateOrganizationUpdateResDTO;
import java.util.List;
import javax.validation.Valid;

/**
 * 特邀调解组织API
 */
@Valid
public interface TeyaoMediateOrganizationServiceApi {

  /**
   * 分页查询
   */
  DubboResult<PageInfo<TeyaoMediateOrganizationListResDTO>> queryPageList(
      TeyaoMediateOrganizationPageListReqDTO pageListReqDTO);

  /**
   * 新增
   */
  DubboResult<TeyaoMediateOrganizationAddResDTO> add(TeyaoMediateOrganizationAddReqDTO addReqDTO);

  /**
   * 修改
   */
  DubboResult<TeyaoMediateOrganizationUpdateResDTO> update(TeyaoMediateOrganizationUpdateReqDTO updateReqDTO);

  /**
   * 详情
   */
  DubboResult<TeyaoMediateOrganizationDetailResDTO> detail(Long orgId);

  /**
   * 审核
   */
  DubboResult auth(TeyaoMediateOrganizationAuthReqDTO authReqDTO);

  /**
   * 出库
   */
  DubboResult out(TeyaoMediateOutStoreReqDTO outReqDTO);

  /**
   * 调解员表彰
   */
  DubboResult commend(TeyaoMediateCommendReqDTO teyaoMediateCommendReqDTO);

  /**
   * 调解员培训信息
   */
  DubboResult study(TeyaoMediateStudyReqDTO teyaoMediateStudyReqDTO);

  /**
   * 生成二维码
   */
  DubboResult<TeyaoMediateOrgCertResDTO> generateCert(Long orgId) throws Exception;

  /**
   * 重新入库
   */
  DubboResult againStore(Long orgId);

  DubboResult deleteOrg(List<Long> ids);

}