package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateUserAuthReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateCommendReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateOutStoreReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateStoreReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateStudyReqDTO;
import com.beiming.odr.user.api.dto.requestdto.TeyaoMediateUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateUserCertResDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateUserDetailResDTO;
import com.beiming.odr.user.api.dto.responsedto.TeyaoMediateUserListResDTO;
import java.util.List;
import javax.validation.Valid;

@Valid
public interface TeyaoMediateUserApi {

  /**
   * 分页查询
   *
   * @param teyaoMediateUserListReqDTO 请求参数
   * @return 特邀用户列表
   */
  DubboResult<PageInfo<TeyaoMediateUserListResDTO>> queryTeyaoMediateUserList(
      TeyaoMediateUserListReqDTO teyaoMediateUserListReqDTO);

  /**
   * 特邀用户详情
   *
   * @param id 主键编号
   */
  DubboResult<TeyaoMediateUserDetailResDTO> detail(Long id);

  /**
   * 特邀用户详情 小程序使用
   *
   * @param userId 用户编号
   */
  DubboResult<TeyaoMediateUserDetailResDTO> detailByMiniApp(Long userId);

  /**
   * 特邀调解员入库
   *
   * @return 入库结果
   */
  DubboResult insertTeyaoMediateUser(TeyaoMediateStoreReqDTO teyaoMediateStoreReqDTO);

  /**
   * 审核
   *
   * @param teyaoMediateUserAuthReqDTO 请求参数
   * @return 审批结果
   */
  DubboResult auth(TeyaoMediateUserAuthReqDTO teyaoMediateUserAuthReqDTO);

  /**
   * 更新信息
   *
   * @return
   */
  DubboResult updateTeyaoMediateUser(TeyaoMediateUserUpdateReqDTO teyaoMediateUserUpdateReqDTO);

  /**
   * 调解员出库
   */
  DubboResult outStore(TeyaoMediateOutStoreReqDTO teyaoMediateOutStoreReqDTO);

  /**
   * 调解员表彰
   */
  DubboResult commendTeyaoMediateUser(TeyaoMediateCommendReqDTO teyaoMediateCommendReqDTO);

  /**
   * 调解员培训信息
   */
  DubboResult study(TeyaoMediateStudyReqDTO teyaoMediateStudyReqDTO);

  /**
   * 生成二维码
   */
  DubboResult<TeyaoMediateUserCertResDTO> generateCert(Long userId) throws Exception;

  /**
   * 生成二维码 小程序使用
   */
  DubboResult<TeyaoMediateUserCertResDTO> generateCertForMiniApp(Long userId) throws Exception;

  /**
   * 重新入库
   */
  DubboResult againStore(Long userId);

  /**
   * 删除调解员（支持批量删除）
   * @param ids 调解员编号集合
   */
  DubboResult deleteTeyaoMediateUsers(List<Long> ids);

}