package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.OpenApiDataResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

@Valid
public interface UserBasicsServiceApi {
  /**
   * 调解员登陆
   * @param mobile
   * @param password
   * @return
   */
  DubboResult<LoginInfoResDTO> mediatorLogin(String mobile, String password, boolean isConselor);

  /**
   * 修改用户最后登陆时间
   * @param userId
   */
  void updateUserLastLandingTime(Long userId);

  DubboResult<ArrayList<OpenApiDataResDTO>> getCaseUserList(List<String> userIdList);
}
