package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.requestdto.UserReportReqDTO;
import com.beiming.odr.user.api.dto.responsedto.AreasResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserReportResDTO;

/**
 * 用户统计报表
 * @author zhiguang
 *
 */
public interface UserReportServiceApi {
  /**
   * 用户统计报表
   * @param userReportReqDTO
   * @param isFromCache
   * @return
   */
  public DubboResult<UserReportResDTO> getUserReport(UserReportReqDTO userReportReqDTO, boolean isFromCache);

  /**
   * 获取yyyy-MM-dd用户访问量
   * @param time
   * @return
   */
  DubboResult<Long> getBaiDuAccess(String time);
  /**
   * 区域管理员所属地区
   * level=2 时查询 areaCode 及其下级code
   * level=3 时查询 areaCode 下的机构
   * @param userId
   * @return
   */
  DubboResult<AreasResDTO> getUserRoleArea(Long userId, String areaCode, Long level);
}
