package com.beiming.odr.user.api;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.PlatformContactInfoDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserStationRelationDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserResetPasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdatePasswordReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.OpenApiReq;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelMediatorSingleInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginNotPasswordReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CommonUserSearchResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.MediatorSingleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.SZSearchServicePersonResDTO;
import com.beiming.odr.user.api.dto.responsedto.SZServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserRoleInfoListResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

@Valid
public interface UserServiceApi {

  /**
   * 新增普通用户
   */
  DubboResult<LoginInfoResDTO> insertCommonUser(
      @Valid CommonUserRegisterReqDTO commonUserRegisterReqDTO);

  /**
   * 新增工作人员用户
   */
  DubboResult<LoginInfoResDTO> insertStaffUser(
      @Valid CommonUserRegisterReqDTO commonUserRegisterReqDTO);

  DubboResult<String> checkWeakPassword(String passWord);

  /**
   * 用户登录 -可以通过mobile也可以通过loginName
   *
   * @param mobile
   * @param password
   * @param loginName
   * @param loginType
   */
  DubboResult<LoginInfoResDTO> userLogin(String mobile, String password, String loginName,
                                         UserLoginTypeEnum loginType);

  /**
   * 赣榆适用
   *
   * @param mobile
   * @return
   */
  DubboResult<LoginInfoResDTO> userLogin(String mobile);


  /**
   * 通过手机号查询普通用户信息(获取用户登录信息)
   */
  DubboResult<LoginInfoResDTO> getUserLoginByMobilePhone(String mobilePhone);

  /**
   * 通过手机号查询工作人员用户信息(获取用户登录信息)
   */
  DubboResult<LoginInfoResDTO> getStaffUserLoginByMobilePhone(String mobilePhone);

  /**
   * 根据id查询
   *
   * @param id
   * @return
   */
  DubboResult<UserInfoDTO> searchUserInfoByUserId(Long id);

  /**
   * 更新普通用户
   */
  DubboResult updateCommonUser(CommonUserUpdateReqDTO commonUserUpdateReqDTO);

  /**
   * 重置登录密码
   *
   * @param commonUserResetPasswordReqDTO
   */
  DubboResult resetUserPassword(@Valid CommonUserResetPasswordReqDTO commonUserResetPasswordReqDTO);

  /**
   * 人脸识别通过-设置
   *
   * @param UserBasicsId 用户ID
   */
  DubboResult setFacialVerify(Long userBasicsId);


  /**
   * 实名认证-设置
   */
  DubboResult setRealNameAuthentication(Long userId,
                                        RealNameAuthenticationReqDTO realNameAuthenticationReqDTO);

  /**
   * 查询普通用户的信息
   */
  DubboResult<CommonUserSearchResDTO> searchCommonUser(CommonIdReqDTO commonIdReqDTO);

  /**
   * 查询服务人员列表分页
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonListPage(ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 海事法院调解员名录分页
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getHsPersonListPage(ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 查询服务人员列表分页(根据机构ID)
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getStaffListByOrgId(ServicePersonListReqDTO servicePersonListReqDTO);

  /**
   * 案件用户注册接口
   */
  DubboResult<CaseUserRegisterResDTO> caseUserregister(@Valid CaseUserRegisterReqDTO caseUserRegisterReqDTO);

  /**
   * 修改密码
   *
   * @param commonUserUpdatePasswordReqDTO
   */
  DubboResult updatePassword(CommonUserUpdatePasswordReqDTO commonUserUpdatePasswordReqDTO);

  DubboResult updatePasswordV2(CommonUserUpdatePasswordReqDTO commonUserUpdatePasswordReqDTO);

  /**
   * 修改手机号码
   */
  DubboResult updateMobilePhone(Long userId, String mobilePhone);

  /**
   * 修改邮箱
   */
  DubboResult updateEmail(Long userId, String email);

  /**
   * 用过手机号码判断用户是否存在
   *
   * @param mobile         手机号码
   * @param personTypeEnum 人员类型
   * @return true 存在 false 不存在
   */
  DubboResult<Boolean> checkUserByMobile(String mobile, PersonTypeEnum personTypeEnum);

  /**
   * 获取用户角色信息
   *
   * @param userId 用户id
   * @param orgId  机构id
   */
  DubboResult<UserRoleInfoListResDTO> getRoleInfoByUserId(Long userId);

  /**
   * 获取用户机构id
   *
   * @param userId 用户id
   */
  DubboResult<UserRoleInfoListResDTO> getOrgByUserId(Long userId);

  /**
   * 获取用户机构对象
   * @param userId
   * @return
   */
  DubboResult<UserRoleInfoListResDTO> getOrgDTOByUserId(Long userId);


  /**
   * 获取内部测试用户userId
   *
   * @return
   */
  DubboResult<String> getInternalTestUserId();

  /**
   * 保存内部测试用户userId,id以逗号隔开
   *
   * @return
   */
  DubboResult saveInternalTestUserId(String userId);

  /**
   * 获取内部测试机构id
   *
   * @return
   */
  DubboResult<String> getInternalTestOrgId();

  /**
   * 保存内部测试机构id,id以逗号隔开
   *
   * @return
   */
  DubboResult saveInternalTestOrgId(String orgId);

  /**
   * 校验姓名和身份证是否匹配
   *
   * @return
   */
  DubboResult<Boolean> checkRealNameAuthentication(RealNameAuthenticationReqDTO req);

  /**
   * 根据区域代码查询下面的所有调解员
   * 只需要传区域代码
   *
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListByAreaCode(@Valid SelMediatorSingleInfoReqDTO arg0);

  /**
   * <pre>
   * 根据机构号查询该机构下的所有调解员
   * 只需要传机构代码
   * @param arg0
   * @return
   */
  DubboResult<ArrayList<MediatorSingleInfoResDTO>> selMediatorSingleInfoListWithOrgManage(@Valid SelMediatorSingleInfoReqDTO arg0);

  /***
   *  删除 用户密码是默认8个8，确已经登录的用户（app和小程序）
   * */
  DubboResult<ArrayList<Long>> deleteUserLoginToken();


  /**
   * 用户登录 -无需密码
   *
   * @param UserLoginNotPasswordReqDTO req
   */
  DubboResult<LoginInfoResDTO> userLoginNotPassword(UserLoginNotPasswordReqDTO req);

  DubboResult<CommonUserSearchResDTO> searchUserByMobile(String mobile,
                                                         PersonTypeEnum personTypeEnum);

  /**
   * 获取用户注册数
   *
   * @return
   */
  DubboResult<Long> selectUserCount(String time);

  /**
   * 获取机构调解员数
   *
   * @param orgId
   * @return
   */
  DubboResult<JSONObject> selectStaffUserOrgCount(String time, Long orgId);

  /**
   * 获取机构调解员上线数
   *
   * @param orgId
   * @return
   */
  DubboResult<JSONObject> selectCamOnlineFuture(String time, Long orgId);

  /**
   * 获取机构调解员上线数
   *
   * @param orgId
   * @return
   */
  DubboResult<JSONObject> selectCamTeyaoCountFuture(String time, Long orgId);

  List<PlatformContactInfoDTO> listPlatformMediatorByIds(List<Long> userIdSet);

  /**
   * 判断用户是否指定机构管理员
   *
   * @param orgId  机构id
   * @param userId 用户id
   * @return
   */
  DubboResult checkOrgAdmin(Long orgId, Long userId);

  DubboResult<ArrayList<UserStationRelationDTO>> getStationAndUsers();

  DubboResult<ArrayList<BackstageOrganizationResDTO>> getOrgUsersForVideo();

  DubboResult getIdcardById(String currentUserId);

  DubboResult<PageInfo<SZServicePersonListResDTO>> getServicePersonPageBySz(OpenApiReq req);

  DubboResult<SZSearchServicePersonResDTO> getServicePersonDetail(OpenApiReq req);
}
