package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchRoleUserInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserExcelReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BatchUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.RecommendMediatorInfoDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleUserInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserOrgPersonResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;


/***
 * @see 用户api中已经放不下了，特此新建第二个用户api
 */
@Valid
public interface UserServiceSecondApi {

  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   *
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   */
  DubboResult<UserInfoDTO> searchAndRegisterByMobileCommon(String mobilePhone, String userName);

  /**
   * 通过用户id查询用户信息
   *
   * @param mobilePhone 手机号码
   */
  DubboResult<ArrayList<UserInfoDTO>> searchUserInfoByUserId(List<Long> list);

  /**
   * 通过用户id查询用户信息
   */
  DubboResult<ArrayList<UserInfoDTO>> searchUserInfo(List<String> userIds);

  /**
   * 查询角色用户信息
   *
   * @param mobilePhone 手机号码
   */
  DubboResult<UserInfoDTO> searchRoleUserInfo(SearchRoleUserInfoReqDTO param);

  /**
   * 实名认证和人脸识别一起设置
   */
  DubboResult setRealNameAndFacialVerify(Long userId, RealNameAuthenticationReqDTO requestDTO);

  /**
   * 批量注册 用过手机号码列表
   *
   * @param mobilePhone 手机号码
   * @see 不做数据的任何校验，就做简单的插入。数据校验，调用该接口时，自己校验
   */
  DubboResult<ArrayList<BatchUserRegisterResDTO>> batchUserRegister(List<String> list);

  /**
   * excel批量导入调解员及角色
   */
  DubboResult<ArrayList<String>> addMediatorForSuperAdmin(List<UserExcelReqDTO> user, String userId,
      String userName);

  /**
   * 获取推荐用户的相关信息
   */
  DubboResult<RecommendMediatorInfoDTO> getMediatorDetailInfo(String mediatorId);

  DubboResult<Boolean> checkOrgMangeByJWT(Long userId, Long orgId);
  DubboResult<UserRoleInfoDTO> getRoleInfoByUserId(Long userId, Long orgId);

  /**
   * 根据人员类型查询用户
   */
  DubboResult<ArrayList<RoleUserInfoResDTO>> searchUserInfoForRoleType();
}
