package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.WorkRegisterDTO;
import com.beiming.odr.user.api.dto.requestdto.WorkRegisterParamDTO;
import com.beiming.odr.user.api.dto.responsedto.ChartsResponseDTO;
import com.beiming.odr.user.api.dto.responsedto.StationListDTO;
import java.util.Date;


public interface WorkRegisterServiceApi {

  /**
   * 工作登记新增
   */
  DubboResult<Integer> add(WorkRegisterDTO workRegisterDTO);

  /**
   * 工作登记修改
   * @param workRegisterDTO
   * @return
   */
  DubboResult update(WorkRegisterDTO workRegisterDTO);

  /**
   * 查询工作登记详情
   * @param workRegisterDTO
   * @return
   */
  DubboResult<WorkRegisterDTO> detail(WorkRegisterDTO workRegisterDTO);

  /**
   * 工作登记删除
   * @param workRegisterDTO
   * @return
   */
  DubboResult delete(WorkRegisterDTO workRegisterDTO);

  /**
   * 工作登记列表
   * @param parm
   * @return
   */
  DubboResult<PageInfo<WorkRegisterDTO>> getList(WorkRegisterParamDTO parm);

  DubboResult<StationListDTO> getTypeList();

  DubboResult<ChartsResponseDTO> statisticScreen(String orgName, Date startTime, Date endTime);
}
