package com.beiming.odr.user.api.common.constants;


import com.beiming.odr.user.api.enums.DisputeTypeEnum;
import java.util.HashMap;

public class OldDisputeTypeMapping {


  /**
   * 旧案由和新案由disputeTypeCode映射
   */
  private static HashMap<String, String> oldAndNewDisputeTypeCodeMapping = new HashMap<>();


  static {
    oldAndNewDisputeTypeCodeMapping.put("MARITAL_INHERITANCE", "9013"); //婚姻家事
    oldAndNewDisputeTypeCodeMapping.put("ADJACENCY_RELATION", "9075"); //相邻关系
    oldAndNewDisputeTypeCodeMapping.put("HOUSE_SITE", "9099"); //宅基地
    oldAndNewDisputeTypeCodeMapping.put("CONTRACT_DISPUTE", "9131"); //合同纠纷
    oldAndNewDisputeTypeCodeMapping.put("PROD_DISPUTE", "6012"); //生产经营
    oldAndNewDisputeTypeCodeMapping.put("DAMAGES_DISPUTE", "9051"); //损害赔偿
    oldAndNewDisputeTypeCodeMapping.put("LAND_DISPUTE", "9887"); //山林土地
    oldAndNewDisputeTypeCodeMapping.put("LAND_DEMOLITION", "6047"); //征地拆迁
    oldAndNewDisputeTypeCodeMapping.put("ENVIR_DISPUTE", "9726"); //环境污染
    oldAndNewDisputeTypeCodeMapping.put("DEFAULT_DISPUTE", "9468"); //拖欠农民工工资
    oldAndNewDisputeTypeCodeMapping.put("LOBOR_DISPUTE", "9462"); //劳动争议
    oldAndNewDisputeTypeCodeMapping.put("TOURISM_DISPUTE", "9270"); //旅游纠纷
    oldAndNewDisputeTypeCodeMapping.put("E_BUSINESS_DISPUTE", "9542"); //电子商务
    oldAndNewDisputeTypeCodeMapping.put("CONSUMER_DISPUTE", "9706"); //消费纠纷
    oldAndNewDisputeTypeCodeMapping.put("MEDICAL_DISPUTE", "9706"); //医疗纠纷
    oldAndNewDisputeTypeCodeMapping.put("ROAD_DISPUTE", "9706"); //道路交通事故
    oldAndNewDisputeTypeCodeMapping.put("PROPERTY_DISPUTE", "9706"); //物业纠纷
    oldAndNewDisputeTypeCodeMapping
        .put("OTHER_DISPUTES", DisputeTypeEnum.CIVIL_OTHER_DISPUTE.getCode().toString()); //其他纠纷
    oldAndNewDisputeTypeCodeMapping.put("LOAN_DISPUTE", "9181"); //民事借贷
    oldAndNewDisputeTypeCodeMapping.put("FINANCE_DISPUTE", "9542"); //金融纠纷
    oldAndNewDisputeTypeCodeMapping.put("PRICE_DISPUTE", "9706"); //价格争议纠纷
    oldAndNewDisputeTypeCodeMapping.put("INTELLECTUAL_PROPERTY_DISPUTE", "9299"); //知识产权纠纷
    oldAndNewDisputeTypeCodeMapping
        .put("OVERSEAS_DISPUTE", DisputeTypeEnum.CIVIL_OTHER_DISPUTE.getCode().toString()); //涉侨纠纷
  }

  public static String getNewDisputeTypeCodeByOld(String disputeTypeOldCode) {
    return oldAndNewDisputeTypeCodeMapping.get(disputeTypeOldCode);
  }


}
