package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;

/**
 * 调解类型枚举
 * @author zhiguang
 */
public enum MediationTypeEnum {
  PEOPLE_MEDIATION("人民调解"),
  ADMINISTRATION_MEDIATION("行政调解"),
  //ARBITRATE_MEDIATION("仲裁调解"),
  JUDICIAL_MEDIATION("司法调解"),
  JUDICIAL_MEDIATION_ADM("司法调解-行政案由"),
  COURT_MEDIATION("法院调解"),
  //BUSINESS_MEDIATION("商业调解"),
  LAWYER_MEDIATION("律师调解"),
  //NOTARIAL_MEDIATION("公证调解"),
  //MAJOR_MEDIATION("专业调解"),
  INDUSTRY_MEDIATION("行业调解"),
  //OTHER_MEDIATION("其他调解"),
  ADMINISTRATIVE_RECONSIDERATION("行政复议"),
  ADMINISTRATIVE_ADJUDICATION("行政裁决"),
  NOTARIZATION("公证"),
  FAST_MEDIATION("快速调解"),
  HUAI_AN_MEDIATION("淮安调解"),
  ZDZ_TEYAO_MEDIATION("总对总调解"),
  SOURCE_GOVERN("诉源治理"),
  ARBITRATION("仲裁"),
  ZDZ_TEYAO_MEDIATE_ORG("总对总");

  private String name;

  MediationTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static String[] getNames() {
    MediationTypeEnum[] enums = MediationTypeEnum.values();
    String names[] = new String[enums.length];
    for (int i = 0; i < enums.length; i++) {
      names[i] = enums[i].getName();
    }
    return names;
  }

  public static HashMap<String, String> getNameEnumNameMap() {
    HashMap<String, String> map = new HashMap<String, String>();
    for (MediationTypeEnum type : MediationTypeEnum.values()) {
      map.put(type.getName(), type.name());
    }
    return map;
  }
}
