package com.beiming.odr.user.api.common.enums;

import lombok.Getter;

/**
 * 机构特殊标签属性枚举
 */
public enum OrganizationTagEnum {

  /**
   * 以下四个为南京海事法院特殊标签，标记在组织机构tag字段
   * 其他机构可使用该枚举，请自定义
   */
  ONE_STOP_DISPUTE_RESOLUTION_CENTER("一站式解纷中心"),
  CREW_RIGHTS_PROTECTION_CENTER("船员权益保护中心"),
  LITIGATION_SOURCE_MANAGEMENT_WORKSTATION("审务工作站"),
  CIRCUIT_TRIAL_SITE("巡回审判点"),
  ;
  @Getter
  private String desc;

  OrganizationTagEnum(String desc) {
    this.desc = desc;
  }
}
