package com.beiming.odr.user.api.common.enums;

import java.util.HashMap;

/**
 * 机构类型枚举
 * @author fanheshui
 *
 */
public enum OrganizationTypeEnum {

  SOURCE_GOVERN("诉源治理"),
  ZDZ_TEYAO_MEDIATE_ORG("总对总特邀调解组织"),
  TEYAO_MEDIATE_ORG("特邀调解组织"),
  GOLD_MEDIATE_ROOM("金牌调解室"),
  JUDICIAL("司法机关"),
  STREET_COMMITTEE("街道调委会"),
  COMMUNITY_COMMITTEE("居（社区）调委会"),
  OTHER_COMMITTEE("其他调委会"),
  LAW_INSTITUTE("律所");
 
  private String name;


  OrganizationTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }
  
  public static OrganizationTypeEnum getOrganizationTypeEnum(String name) {
    for (OrganizationTypeEnum type : OrganizationTypeEnum.values()) {
      if (type.getName().equals(name)) {
        return type;
      }
    }
    return null;
  }
  public static HashMap<String, String> getNameEnumNameMap() {
    HashMap<String, String> map = new HashMap<String, String>();
    for (OrganizationTypeEnum type : OrganizationTypeEnum.values()) {
      map.put(type.getName(), type.name());
    }
    return map;
  }
  
  public static String[] getNames() {
    OrganizationTypeEnum[] values = OrganizationTypeEnum.values();
    String orgType[] = new String[values.length];
    for (int i = 0; i < values.length; i++) {
      orgType[i] = values[i].getName();
    }
    return orgType;
  }

}
