package com.beiming.odr.user.api.dto;

import com.beiming.odr.user.api.dto.requestdto.StatisticScreenDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author sunjie
 * @description:
 * @date 2023/2/14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class StationInfoDTO extends StatisticScreenDTO implements Serializable {

  /**
   * id
   */
  private Integer id;

  /**
   * 站点类型
   */
  @NotBlank(message = "站点类型不能为空")
  private String orgType;

  @NotBlank(message = "站点类型code不能为空")
  private String orgTypeCode;

  /**
   * 站点名称
   */
  @NotBlank(message = "站点名称不能为空")
  private String orgName;
  private String name;
  private String type;

  /**
   * 联系地址
   */
  @NotBlank(message = "联系地址不能为空")
  private String address;

  /**
   * 拼接后的地址
   */
  private String completeAddress;

  /**
   * 经纬度
   */
  private String lonlat;

  /**
   * 联系方式
   */
  @NotBlank(message = "联系方式不能为空")
  private String contact;

  /**
   * 站点简介
   */
  private String introduce;

  /**
   * 地址所在城市区
   */
  private String city;
  private String provCode;
  private String provName;
  private String cityName;
  private String cityCode;
  private String areaCode;
  private String areaName;
  private String streetCode;
  private String streetName;

  /**
   * 站点图片路径
   */
  private String img;

  /**
   * 工作团队
   */
  private List<USRelationDTO> teamList;

  /**
   * 页码
   */
  private Integer pageIndex;

  /**
   * 每页记录数
   */
  private Integer pageSize;
}
